/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.management.ManagedOperation;
import br.gov.frameworkdemoiselle.management.ManagedProperty;
import br.gov.frameworkdemoiselle.management.OperationParameter;
import br.gov.frameworkdemoiselle.management.OperationType;
import br.gov.frameworkdemoiselle.stereotype.ManagementController;
import br.gov.frameworkdemoiselle.util.NamedQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TreeMap;
import javax.inject.Named;
import javax.inject.Qualifier;

public class ManagedType {
    private Class<?> type;
    private Annotation[] qualifiers;
    private TreeMap<String, FieldDetail> fields;
    private TreeMap<String, MethodDetail> operationMethods;
    private ResourceBundle bundle = new ResourceBundle("demoiselle-core-bundle", Locale.getDefault());
    private String description;

    public ManagedType(Class<?> type) {
        if (type == null) {
            throw new DemoiselleException(this.bundle.getString("management-null-class-defined"));
        }
        if (!type.isAnnotationPresent(ManagementController.class)) {
            throw new DemoiselleException(this.bundle.getString("management-no-annotation-found", type.getCanonicalName()));
        }
        this.type = type;
        this.fields = new TreeMap();
        this.operationMethods = new TreeMap();
        this.description = type.getAnnotation(ManagementController.class).description();
        this.qualifiers = this.getQualifierAnnotations(type);
        this.initialize();
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public TreeMap<String, FieldDetail> getFields() {
        return this.fields;
    }

    public TreeMap<String, MethodDetail> getOperationMethods() {
        return this.operationMethods;
    }

    public Annotation[] getQualifiers() {
        return this.qualifiers;
    }

    private void initialize() {
        Method[] methodList;
        Field[] fields = this.type.getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(ManagedProperty.class)) continue;
                Method getterMethod = this.getGetterMethod(field);
                Method setterMethod = this.getSetterMethod(field);
                if (getterMethod == null && setterMethod == null) {
                    throw new DemoiselleException(this.bundle.getString("management-invalid-property-no-getter-setter", this.type.getSimpleName(), field.getName()));
                }
                if (getterMethod != null && getterMethod.isAnnotationPresent(ManagedOperation.class) || setterMethod != null && setterMethod.isAnnotationPresent(ManagedOperation.class)) {
                    throw new DemoiselleException(this.bundle.getString("management-invalid-property-as-operation", this.type.getSimpleName()));
                }
                String propertyDescription = field.getAnnotation(ManagedProperty.class).description();
                this.fields.put(field.getName(), new FieldDetail(field, propertyDescription, getterMethod, setterMethod));
            }
        }
        if ((methodList = this.type.getMethods()) != null) {
            for (Method method : methodList) {
                ManagedOperation opAnnotation = method.getAnnotation(ManagedOperation.class);
                if (opAnnotation == null) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                ParameterDetail[] parameterDetails = new ParameterDetail[parameterTypes.length];
                OperationType operationType = opAnnotation.type();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    OperationParameter paramAnnotation = null;
                    for (Annotation annotation : parameterAnnotations[i]) {
                        if (annotation.annotationType() != OperationParameter.class) continue;
                        paramAnnotation = (OperationParameter)annotation;
                        break;
                    }
                    String name = paramAnnotation != null ? paramAnnotation.name() : "arg" + i;
                    String description = paramAnnotation != null ? paramAnnotation.description() : null;
                    parameterDetails[i] = new ParameterDetail(parameterTypes[i], name, description);
                }
                MethodDetail detail = new MethodDetail(method, opAnnotation.description(), operationType, parameterDetails);
                this.operationMethods.put(method.getName(), detail);
            }
        }
    }

    private Method getGetterMethod(Field field) {
        Method getterMethod;
        StringBuffer getterMethodName = new StringBuffer().append("get").append(field.getName().substring(0, 1).toUpperCase()).append(field.getName().substring(1));
        ManagedProperty annotation = field.getAnnotation(ManagedProperty.class);
        if (annotation.accessLevel() == ManagedProperty.ManagedPropertyAccess.WRITE_ONLY) {
            return null;
        }
        try {
            getterMethod = this.type.getMethod(getterMethodName.toString(), new Class[0]);
        }
        catch (Exception e) {
            getterMethod = null;
        }
        if (getterMethod == null && (Boolean.TYPE.isAssignableFrom(field.getType()) || Boolean.class.isAssignableFrom(field.getType()))) {
            getterMethodName = new StringBuffer().append("is").append(field.getName().substring(0, 1).toUpperCase()).append(field.getName().substring(1));
            try {
                getterMethod = this.type.getMethod(getterMethodName.toString(), new Class[0]);
            }
            catch (Exception e) {
                getterMethod = null;
            }
        }
        return getterMethod;
    }

    private Method getSetterMethod(Field field) {
        Method setterMethod;
        ManagedProperty annotation = field.getAnnotation(ManagedProperty.class);
        if (annotation.accessLevel() == ManagedProperty.ManagedPropertyAccess.READ_ONLY) {
            return null;
        }
        StringBuffer setterMethodName = new StringBuffer().append("set").append(field.getName().substring(0, 1).toUpperCase()).append(field.getName().substring(1));
        try {
            setterMethod = this.type.getMethod(setterMethodName.toString(), field.getType());
        }
        catch (Exception e) {
            setterMethod = null;
        }
        return setterMethod;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return ((ManagedType)other).getType().getCanonicalName().equals(this.getType().getCanonicalName());
    }

    private synchronized Annotation[] getQualifierAnnotations(Class<?> beanClass) {
        Annotation[] annotations = beanClass.getDeclaredAnnotations();
        ArrayList<Object> qualifiers = new ArrayList<Object>(annotations.length);
        for (int i = 0; i < annotations.length; ++i) {
            if (annotations[i].annotationType().getAnnotation(Qualifier.class) == null) continue;
            if (annotations[i].annotationType().equals(Named.class) && "".equals(((Named)annotations[i]).value())) {
                qualifiers.add((Object)new NamedQualifier(this.formatClassName(beanClass)));
                continue;
            }
            qualifiers.add(annotations[i]);
        }
        return qualifiers.toArray(new Annotation[0]);
    }

    private String formatClassName(Class<?> type) {
        return type.getSimpleName().substring(0, 1).toLowerCase() + type.getSimpleName().substring(1);
    }

    public final class ParameterDetail {
        private final Class<?> parameterType;
        private final String parameterName;
        private final String parameterDescription;

        public ParameterDetail(Class<?> parameterType, String parameterName, String parameterDescription) {
            this.parameterType = parameterType;
            this.parameterName = parameterName;
            this.parameterDescription = parameterDescription;
        }

        public Class<?> getParameterType() {
            return this.parameterType;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getParameterDescription() {
            return this.parameterDescription;
        }
    }

    public final class MethodDetail {
        private final Method method;
        private final ParameterDetail[] parameterTypers;
        private final String description;
        private final OperationType type;

        public MethodDetail(Method method, String description, OperationType type, ParameterDetail[] parameterTypers) {
            this.method = method;
            this.description = description;
            this.type = type;
            this.parameterTypers = parameterTypers;
        }

        public Method getMethod() {
            return this.method;
        }

        public ParameterDetail[] getParameterTypers() {
            return this.parameterTypers;
        }

        public String getDescription() {
            return this.description;
        }

        public OperationType getType() {
            return this.type;
        }
    }

    public final class FieldDetail {
        private final Field field;
        private final String description;
        private Method getterMethod;
        private Method setterMethod;

        public FieldDetail(Field field, String description, Method getterMethod, Method setterMethod) {
            this.field = field;
            this.description = description;
            this.getterMethod = getterMethod;
            this.setterMethod = setterMethod;
        }

        public Field getField() {
            return this.field;
        }

        public String getDescription() {
            return this.description;
        }

        public Method getGetterMethod() {
            return this.getterMethod;
        }

        public Method getSetterMethod() {
            return this.setterMethod;
        }
    }
}

