/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.PassivationCapable;

public class ContextualStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX = ContextualStore.class.getCanonicalName() + "#";
    private final AtomicInteger idGenerator = new AtomicInteger();
    private final ConcurrentMap<String, Contextual> idToContextual = new ConcurrentHashMap<String, Contextual>();
    private final ConcurrentMap<Contextual, String> contextualToId = new ConcurrentHashMap<Contextual, String>();
    private final ConcurrentMap<String, Contextual> passivableIdToContextual = new ConcurrentHashMap<String, Contextual>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putIfAbsentAndGetId(Contextual contextual) {
        String returnedId;
        if (contextual instanceof PassivationCapable) {
            returnedId = ((PassivationCapable)contextual).getId();
            this.passivableIdToContextual.putIfAbsent(returnedId, contextual);
        } else {
            returnedId = (String)this.contextualToId.get(contextual);
            if (returnedId == null) {
                Contextual contextual2 = contextual;
                synchronized (contextual2) {
                    returnedId = (String)this.contextualToId.get(contextual);
                    if (returnedId == null) {
                        returnedId = new StringBuffer().append(PREFIX).append(this.idGenerator.incrementAndGet()).toString();
                        this.idToContextual.put(returnedId, contextual);
                        this.contextualToId.put(contextual, returnedId);
                    }
                }
            }
        }
        return returnedId;
    }

    public Contextual getContextual(String id) {
        if (id.startsWith(PREFIX)) {
            return (Contextual)this.idToContextual.get(id);
        }
        return (Contextual)this.passivableIdToContextual.get(id);
    }

    public void clear() {
        this.idToContextual.clear();
        this.contextualToId.clear();
        this.passivableIdToContextual.clear();
    }
}

