/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.internal.configuration.PaginationConfig;
import br.gov.frameworkdemoiselle.internal.implementation.PaginationImpl;
import br.gov.frameworkdemoiselle.pagination.Pagination;
import br.gov.frameworkdemoiselle.pagination.PaginationContext;
import br.gov.frameworkdemoiselle.util.Beans;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.RequestScoped;

@RequestScoped
public class PaginationContextImpl
implements Serializable,
PaginationContext {
    private static final long serialVersionUID = 1L;
    private PaginationConfig config;
    private final Map<Class<?>, Pagination> cache = new HashMap();

    public PaginationContextImpl() {
        System.out.println();
    }

    @Override
    public Pagination getPagination(Class<?> clazz) {
        return this.getPagination(clazz, false);
    }

    @Override
    public Pagination getPagination(Class<?> clazz, boolean create) {
        Pagination pagination = this.cache.get(clazz);
        if (pagination == null && create) {
            pagination = new PaginationImpl();
            pagination.setPageSize(this.getConfig().getPageSize());
            this.cache.put(clazz, pagination);
        }
        return pagination;
    }

    private PaginationConfig getConfig() {
        if (this.config == null) {
            this.config = Beans.getReference(PaginationConfig.class);
        }
        return this.config;
    }
}

