/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.context.ConversationContext;
import br.gov.frameworkdemoiselle.context.RequestContext;
import br.gov.frameworkdemoiselle.internal.implementation.ManagedType;
import br.gov.frameworkdemoiselle.management.AttributeChangeMessage;
import br.gov.frameworkdemoiselle.management.DefaultNotification;
import br.gov.frameworkdemoiselle.management.ManagedAttributeNotFoundException;
import br.gov.frameworkdemoiselle.management.ManagedInvokationException;
import br.gov.frameworkdemoiselle.management.ManagementExtension;
import br.gov.frameworkdemoiselle.management.NotificationManager;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;

@ApplicationScoped
public class Management
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private Logger logger;
    @Inject
    @Name(value="demoiselle-core-bundle")
    private ResourceBundle bundle;
    private final List<ManagedType> managedTypes = new ArrayList<ManagedType>();
    private Validator validator;

    public void addManagedType(ManagedType managedType) {
        this.managedTypes.add(managedType);
        this.logger.fine(this.bundle.getString("management-debug-registering-managed-type", managedType.getType().getCanonicalName()));
    }

    public List<ManagedType> getManagedTypes() {
        ArrayList<ManagedType> cloneList = new ArrayList<ManagedType>();
        cloneList.addAll(this.managedTypes);
        return cloneList;
    }

    public Object invoke(ManagedType managedType, String actionName, Object[] params) {
        if (this.managedTypes.contains(managedType)) {
            this.activateContexts(managedType.getType());
            try {
                Object delegate = Beans.getReference(managedType.getType(), managedType.getQualifiers());
                ManagedType.MethodDetail method = managedType.getOperationMethods().get(actionName);
                if (method != null) {
                    try {
                        this.logger.fine(this.bundle.getString("management-debug-invoking-operation", actionName, managedType.getType().getCanonicalName()));
                        Object object = method.getMethod().invoke(delegate, params);
                        return object;
                    }
                    catch (Exception e) {
                        throw new ManagedInvokationException(this.bundle.getString("management-invoke-error", actionName), e);
                    }
                }
                throw new ManagedInvokationException(this.bundle.getString("management-invoke-error", actionName));
            }
            finally {
                this.deactivateContexts(managedType.getType());
            }
        }
        throw new ManagedInvokationException(this.bundle.getString("management-type-not-found"));
    }

    public Object getProperty(ManagedType managedType, String propertyName) {
        if (this.managedTypes.contains(managedType)) {
            Method getterMethod = managedType.getFields().get(propertyName).getGetterMethod();
            if (getterMethod != null) {
                this.logger.fine(this.bundle.getString("management-debug-acessing-property", getterMethod.getName(), managedType.getType().getCanonicalName()));
                this.activateContexts(managedType.getType());
                try {
                    Object delegate = Beans.getReference(managedType.getType(), managedType.getQualifiers());
                    Object object = getterMethod.invoke(delegate, null);
                    return object;
                }
                catch (Exception e) {
                    throw new ManagedInvokationException(this.bundle.getString("management-invoke-error", getterMethod.getName()), e);
                }
                finally {
                    this.deactivateContexts(managedType.getType());
                }
            }
            throw new ManagedAttributeNotFoundException(this.bundle.getString("management-read-value-error", propertyName));
        }
        throw new ManagedInvokationException(this.bundle.getString("management-type-not-found"));
    }

    public void setProperty(ManagedType managedType, String propertyName, Object newValue) {
        block15: {
            if (this.managedTypes.contains(managedType)) {
                Method method = managedType.getFields().get(propertyName).getSetterMethod();
                if (method != null) {
                    this.logger.fine(this.bundle.getString("management-debug-setting-property", method.getName(), managedType.getType().getCanonicalName()));
                    this.activateContexts(managedType.getType());
                    try {
                        try {
                            Object oldValue;
                            Object delegate = Beans.getReference(managedType.getType(), managedType.getQualifiers());
                            Validator validator = this.getDefaultValidator();
                            if (validator != null) {
                                Set violations = validator.validateValue(managedType.getType(), propertyName, newValue, new Class[0]);
                                if (violations.size() > 0) {
                                    StringBuffer errorBuffer = new StringBuffer();
                                    for (Object objectViolation : violations) {
                                        ConstraintViolation violation = (ConstraintViolation)objectViolation;
                                        errorBuffer.append(violation.getMessage()).append('\r').append('\n');
                                    }
                                    if (errorBuffer.length() > 0) {
                                        errorBuffer.insert(0, "\r\n");
                                        errorBuffer.insert(errorBuffer.length(), "\r\n");
                                    }
                                    throw new ConstraintViolationException(this.bundle.getString("management-validation-constraint-violation", managedType.getType().getCanonicalName(), propertyName, errorBuffer.toString()), violations);
                                }
                            } else {
                                this.logger.warning(this.bundle.getString("management-validation-validator-not-found"));
                            }
                            Method getterMethod = managedType.getFields().get(propertyName).getGetterMethod();
                            try {
                                oldValue = getterMethod.invoke(delegate, null);
                            }
                            catch (Exception e) {
                                oldValue = null;
                            }
                            method.invoke(delegate, newValue);
                            NotificationManager notificationManager = Beans.getReference(NotificationManager.class);
                            Class<?> attributeType = newValue != null ? newValue.getClass() : null;
                            DefaultNotification notification = new DefaultNotification(new AttributeChangeMessage(this.bundle.getString("management-notification-attribute-changed", propertyName, managedType.getType().getCanonicalName()), propertyName, attributeType, oldValue, newValue));
                            notificationManager.sendNotification(notification);
                            break block15;
                        }
                        catch (ConstraintViolationException ce) {
                            throw ce;
                        }
                        catch (Exception e) {
                            throw new ManagedInvokationException(this.bundle.getString("management-invoke-error", method.getName()), e);
                        }
                    }
                    finally {
                        this.deactivateContexts(managedType.getType());
                    }
                }
                throw new ManagedAttributeNotFoundException(this.bundle.getString("management-write-value-error", propertyName));
            }
            throw new ManagedInvokationException(this.bundle.getString("management-type-not-found"));
        }
    }

    private void activateContexts(Class<?> managedType) {
        RequestContext requestContext = Beans.getReference(RequestContext.class);
        ConversationContext conversationContext = Beans.getReference(ConversationContext.class);
        if (!requestContext.isActive()) {
            this.logger.fine(this.bundle.getString("management-debug-starting-custom-context", requestContext.getClass().getCanonicalName(), managedType.getCanonicalName()));
            requestContext.activate();
        }
        if (!conversationContext.isActive()) {
            this.logger.fine(this.bundle.getString("management-debug-starting-custom-context", conversationContext.getClass().getCanonicalName(), managedType.getCanonicalName()));
            conversationContext.activate();
        }
    }

    private void deactivateContexts(Class<?> managedType) {
        RequestContext requestContext = Beans.getReference(RequestContext.class);
        ConversationContext conversationContext = Beans.getReference(ConversationContext.class);
        if (requestContext.isActive()) {
            this.logger.fine(this.bundle.getString("management-debug-stoping-custom-context", requestContext.getClass().getCanonicalName(), managedType.getCanonicalName()));
            requestContext.deactivate();
        }
        if (conversationContext.isActive()) {
            this.logger.fine(this.bundle.getString("management-debug-stoping-custom-context", conversationContext.getClass().getCanonicalName(), managedType.getCanonicalName()));
            conversationContext.deactivate();
        }
    }

    public void shutdown(Collection<Class<? extends ManagementExtension>> monitoringExtensions) {
        for (Class<? extends ManagementExtension> monitoringExtensionClass : monitoringExtensions) {
            ManagementExtension monitoringExtension = Beans.getReference(monitoringExtensionClass);
            monitoringExtension.shutdown(this.getManagedTypes());
            this.logger.fine(this.bundle.getString("management-debug-removing-management-extension", monitoringExtension.getClass().getCanonicalName()));
        }
    }

    public void initialize(Collection<Class<? extends ManagementExtension>> monitoringExtensions) {
        for (Class<? extends ManagementExtension> monitoringExtensionClass : monitoringExtensions) {
            ManagementExtension monitoringExtension = Beans.getReference(monitoringExtensionClass);
            this.logger.fine(this.bundle.getString("management-debug-processing-management-extension", monitoringExtension.getClass().getCanonicalName()));
            monitoringExtension.initialize(this.getManagedTypes());
        }
    }

    private Validator getDefaultValidator() {
        if (this.validator == null) {
            try {
                this.validator = Validation.buildDefaultValidatorFactory().getValidator();
            }
            catch (ValidationException e) {
                this.validator = null;
            }
        }
        return this.validator;
    }
}

