/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.configuration.ConfigurationValueExtractor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;

@Priority(value=2147483547)
public class ConfigurationMapValueExtractor
implements ConfigurationValueExtractor {
    @Override
    public Object getValue(String prefix, String key, Field field, Configuration configuration) throws Exception {
        HashMap<String, String> value = null;
        String regexp = "^(" + prefix + ")(" + key + ")(\\.(\\w+))?$";
        Pattern pattern = Pattern.compile(regexp);
        Iterator iter = configuration.getKeys();
        while (iter.hasNext()) {
            String iterKey = (String)iter.next();
            Matcher matcher = pattern.matcher(iterKey);
            if (!matcher.matches()) continue;
            String confKey = String.valueOf(matcher.group(1)) + matcher.group(2) + (matcher.group(3) != null ? matcher.group(3) : "");
            if (value == null) {
                value = new HashMap<String, String>();
            }
            String mapKey = matcher.group(4) == null ? "default" : matcher.group(4);
            value.put(mapKey, configuration.getString(confKey));
        }
        return value;
    }

    @Override
    public boolean isSupported(Field field) {
        return field.getType() == Map.class;
    }
}

