/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.configuration.ConfigurationValueExtractor;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.reflect.Field;
import java.util.Locale;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;

@Priority(value=2147483547)
public class ConfigurationEnumValueExtractor
implements ConfigurationValueExtractor {
    private transient ResourceBundle bundle;

    @Override
    public Object getValue(String prefix, String key, Field field, Configuration configuration) throws Exception {
        String value = configuration.getString(String.valueOf(prefix) + key);
        if (value != null && !value.trim().equals("")) {
            ?[] enums = field.getType().getEnumConstants();
            int i = 0;
            while (i < enums.length) {
                if (((Enum)enums[i]).name().equals(value)) {
                    return enums[i];
                }
                ++i;
            }
        } else {
            return null;
        }
        throw new ConversionException(this.getBundle().getString("configuration-not-conversion", value, field.getDeclaringClass().getCanonicalName()));
    }

    @Override
    public boolean isSupported(Field field) {
        return field.getType().isEnum();
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = new ResourceBundle("demoiselle-core-bundle", Locale.getDefault());
        }
        return this.bundle;
    }
}

