/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.implementation.ManagedType;
import br.gov.frameworkdemoiselle.internal.implementation.Management;
import br.gov.frameworkdemoiselle.lifecycle.AfterShutdownProccess;
import br.gov.frameworkdemoiselle.management.ManagementExtension;
import br.gov.frameworkdemoiselle.stereotype.ManagementController;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

public class ManagementBootstrap
implements Extension {
    protected List<AnnotatedType<?>> types = Collections.synchronizedList(new ArrayList());
    private List<Class<? extends ManagementExtension>> managementExtensionCache = Collections.synchronizedList(new ArrayList());

    public <T> void detectAnnotation(@Observes ProcessAnnotatedType<T> event, BeanManager beanManager) {
        if (event.getAnnotatedType().isAnnotationPresent(ManagementController.class)) {
            this.types.add(event.getAnnotatedType());
        }
    }

    public void registerAvailableManagedTypes(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        ResourceBundle bundle = new ResourceBundle("demoiselle-core-bundle", Locale.getDefault());
        Management monitoringManager = Beans.getReference(Management.class);
        for (AnnotatedType<?> type : this.types) {
            if (type.getJavaClass().isInterface() || Modifier.isAbstract(type.getJavaClass().getModifiers())) {
                throw new DemoiselleException(bundle.getString("management-abstract-class-defined", type.getJavaClass().getCanonicalName()));
            }
            ManagedType managedType = new ManagedType(type.getJavaClass());
            monitoringManager.addManagedType(managedType);
        }
        Set extensionBeans = beanManager.getBeans(ManagementExtension.class, new Annotation[0]);
        if (extensionBeans != null) {
            for (Bean bean : extensionBeans) {
                Class extensionConcreteClass = bean.getBeanClass();
                this.managementExtensionCache.add(extensionConcreteClass);
            }
        }
        monitoringManager.initialize(this.managementExtensionCache);
    }

    public void unregisterAvailableManagedTypes(@Observes AfterShutdownProccess event) {
        Management manager = Beans.getReference(Management.class);
        manager.shutdown(this.managementExtensionCache);
        this.managementExtensionCache.clear();
        this.types.clear();
    }
}

