/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.internal.implementation.StrategySelector;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.message.DefaultMessage;
import br.gov.frameworkdemoiselle.message.MessageAppender;
import br.gov.frameworkdemoiselle.message.MessageContext;
import br.gov.frameworkdemoiselle.message.SeverityType;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.logging.Logger;

public class MessageContextImpl
implements Serializable,
MessageContext {
    private static final long serialVersionUID = 1L;
    private transient ResourceBundle bundle;
    private transient Logger logger;

    private MessageAppender getAppender() {
        Class<MessageAppender> appenderClass = StrategySelector.selectClass(MessageAppender.class);
        return Beans.getReference(appenderClass);
    }

    @Override
    public void add(String text, Object ... params) {
        this.add(text, null, params);
    }

    @Override
    public void add(String text, SeverityType severity, Object ... params) {
        this.getAppender().append(new DefaultMessage(text, severity, params), new Object[0]);
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerProducer.create("br.gov.frameworkdemoiselle.message");
        }
        return this.logger;
    }
}

