/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.context.ConversationContext;
import br.gov.frameworkdemoiselle.context.CustomContext;
import br.gov.frameworkdemoiselle.context.RequestContext;
import br.gov.frameworkdemoiselle.context.SessionContext;
import br.gov.frameworkdemoiselle.context.ViewContext;
import br.gov.frameworkdemoiselle.internal.bootstrap.CustomContextBootstrap;
import br.gov.frameworkdemoiselle.internal.context.TemporaryViewContextImpl;
import br.gov.frameworkdemoiselle.internal.implementation.AnnotatedMethodProcessor;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.Reflections;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

public abstract class AbstractLifecycleBootstrap<A extends Annotation>
implements Extension {
    private Class<A> annotationClass;
    private List<AnnotatedMethodProcessor> processors = Collections.synchronizedList(new ArrayList());
    private static transient ResourceBundle bundle;
    private boolean registered = false;
    private HashMap<String, Boolean> startedContextHere = new HashMap();
    private transient CustomContext backupContext = null;

    protected abstract Logger getLogger();

    protected static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return bundle;
    }

    protected <T> AnnotatedMethodProcessor<T> newProcessorInstance(AnnotatedMethod<T> annotatedMethod) {
        return new AnnotatedMethodProcessor<T>(annotatedMethod);
    }

    protected Class<A> getAnnotationClass() {
        if (this.annotationClass == null) {
            this.annotationClass = Reflections.getGenericTypeArgument(this.getClass(), 0);
        }
        return this.annotationClass;
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        for (AnnotatedMethod am : annotatedType.getMethods()) {
            if (!am.isAnnotationPresent(this.getAnnotationClass())) continue;
            this.processors.add(this.newProcessorInstance(am));
        }
    }

    protected synchronized void proccessEvent() {
        this.getLogger().fine(AbstractLifecycleBootstrap.getBundle().getString("executing-all", this.getAnnotationClass().getSimpleName()));
        Collections.sort(this.processors);
        Exception failure = null;
        this.startContexts();
        Iterator<AnnotatedMethodProcessor> iter = this.processors.iterator();
        while (iter.hasNext()) {
            AnnotatedMethodProcessor processor = iter.next();
            try {
                ClassLoader classLoader = Reflections.getClassLoaderForClass(processor.getAnnotatedMethod().getDeclaringType().getJavaClass().getCanonicalName());
                if (!Thread.currentThread().getContextClassLoader().equals(classLoader)) continue;
                processor.process(new Object[0]);
                iter.remove();
            }
            catch (Exception cause) {
                failure = cause;
            }
        }
        this.stopContexts();
        if (failure != null) {
            throw new DemoiselleException(failure);
        }
    }

    private void startContexts() {
        if (!this.registered) {
            RequestContext requestContext = Beans.getReference(RequestContext.class);
            SessionContext sessionContext = Beans.getReference(SessionContext.class);
            ViewContext viewContext = Beans.getReference(ViewContext.class);
            ConversationContext conversationContext = Beans.getReference(ConversationContext.class);
            if (requestContext != null) {
                this.startedContextHere.put("request", requestContext.activate());
            }
            if (sessionContext != null) {
                this.startedContextHere.put("session", sessionContext.activate());
            }
            if (conversationContext != null) {
                this.startedContextHere.put("conversation", conversationContext.activate());
            }
            if (viewContext != null) {
                if (TemporaryViewContextImpl.class.isInstance(viewContext)) {
                    this.startedContextHere.put("view", viewContext.activate());
                } else if (viewContext.isActive()) {
                    this.backupContext = viewContext;
                    viewContext.deactivate();
                    CustomContextBootstrap customContextBootstrap = Beans.getReference(CustomContextBootstrap.class);
                    for (CustomContext customContext : customContextBootstrap.getCustomContexts()) {
                        if (!TemporaryViewContextImpl.class.isInstance(customContext)) continue;
                        this.startedContextHere.put("view", customContext.activate());
                        break;
                    }
                }
            }
            this.registered = true;
        }
    }

    private void stopContexts() {
        if (this.registered) {
            RequestContext requestContext = Beans.getReference(RequestContext.class);
            SessionContext sessionContext = Beans.getReference(SessionContext.class);
            ViewContext viewContext = Beans.getReference(ViewContext.class);
            ConversationContext conversationContext = Beans.getReference(ConversationContext.class);
            if (requestContext != null && Boolean.TRUE.equals(this.startedContextHere.get("request"))) {
                requestContext.deactivate();
            }
            if (sessionContext != null && Boolean.TRUE.equals(this.startedContextHere.get("session"))) {
                sessionContext.deactivate();
            }
            if (conversationContext != null && Boolean.TRUE.equals(this.startedContextHere.get("conversation"))) {
                conversationContext.deactivate();
            }
            if (viewContext != null && TemporaryViewContextImpl.class.isInstance(viewContext) && this.startedContextHere.get("view").booleanValue()) {
                viewContext.deactivate();
                if (this.backupContext != null) {
                    this.backupContext.activate();
                    this.backupContext = null;
                }
            }
        }
    }
}

