/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.security;

import br.gov.frameworkdemoiselle.security.AuthorizationException;
import br.gov.frameworkdemoiselle.security.RequiredRole;
import br.gov.frameworkdemoiselle.security.SecurityContext;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

@Interceptor
@RequiredRole(value={""})
public class RequiredRoleInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static transient ResourceBundle bundle;
    private static transient Logger logger;

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        List<String> roles = this.getRoles(ic);
        if (this.getSecurityContext().isLoggedIn()) {
            RequiredRoleInterceptor.getLogger().info(RequiredRoleInterceptor.getBundle().getString("has-role-verification", this.getSecurityContext().getUser().getId(), roles));
        }
        ArrayList<String> userRoles = new ArrayList<String>();
        for (String role : roles) {
            if (!this.getSecurityContext().hasRole(role)) continue;
            userRoles.add(role);
        }
        if (userRoles.isEmpty()) {
            RequiredRoleInterceptor.getLogger().error(RequiredRoleInterceptor.getBundle().getString("does-not-have-role", this.getSecurityContext().getUser().getId(), roles));
            throw new AuthorizationException(RequiredRoleInterceptor.getBundle().getString("does-not-have-role-ui", roles));
        }
        RequiredRoleInterceptor.getLogger().debug(RequiredRoleInterceptor.getBundle().getString("user-has-role", this.getSecurityContext().getUser().getId(), userRoles));
        return ic.proceed();
    }

    private List<String> getRoles(InvocationContext ic) {
        String[] roles = new String[]{};
        roles = ic.getMethod().getAnnotation(RequiredRole.class) == null ? ic.getTarget().getClass().getAnnotation(RequiredRole.class).value() : ic.getMethod().getAnnotation(RequiredRole.class).value();
        return Arrays.asList(roles);
    }

    private SecurityContext getSecurityContext() {
        return Beans.getReference(SecurityContext.class);
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return bundle;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = Beans.getReference(Logger.class, new NameQualifier(RequiredRoleInterceptor.class.getName()));
        }
        return logger;
    }
}

