/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.security;

import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.security.AuthorizationException;
import br.gov.frameworkdemoiselle.security.RequiredPermission;
import br.gov.frameworkdemoiselle.security.SecurityContext;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import br.gov.frameworkdemoiselle.util.Strings;
import java.io.Serializable;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

@Interceptor
@RequiredPermission
public class RequiredPermissionInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static transient ResourceBundle bundle;
    private static transient Logger logger;

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        String resource = this.getResource(ic);
        String operation = this.getOperation(ic);
        String username = null;
        if (this.getSecurityContext().isLoggedIn()) {
            username = this.getSecurityContext().getUser().getId();
            RequiredPermissionInterceptor.getLogger().trace(RequiredPermissionInterceptor.getBundle().getString("access-checking", username, operation, resource));
        }
        if (!this.getSecurityContext().hasPermission(resource, operation)) {
            RequiredPermissionInterceptor.getLogger().error(RequiredPermissionInterceptor.getBundle().getString("access-denied", username, operation, resource));
            throw new AuthorizationException(RequiredPermissionInterceptor.getBundle().getString("access-denied-ui", resource, operation));
        }
        RequiredPermissionInterceptor.getLogger().debug(RequiredPermissionInterceptor.getBundle().getString("access-allowed", username, operation, resource));
        return ic.proceed();
    }

    private String getResource(InvocationContext ic) {
        RequiredPermission requiredPermission = ic.getMethod().getAnnotation(RequiredPermission.class);
        if (requiredPermission == null) {
            requiredPermission = ic.getTarget().getClass().getAnnotation(RequiredPermission.class);
        }
        if (Strings.isEmpty(requiredPermission.resource())) {
            if (ic.getTarget().getClass().getAnnotation(Name.class) == null) {
                return ic.getTarget().getClass().getSimpleName();
            }
            return ic.getTarget().getClass().getAnnotation(Name.class).value();
        }
        return requiredPermission.resource();
    }

    private String getOperation(InvocationContext ic) {
        RequiredPermission requiredPermission = ic.getMethod().getAnnotation(RequiredPermission.class);
        if (requiredPermission == null) {
            requiredPermission = ic.getTarget().getClass().getAnnotation(RequiredPermission.class);
        }
        if (Strings.isEmpty(requiredPermission.operation())) {
            if (ic.getMethod().getAnnotation(Name.class) == null) {
                return ic.getMethod().getName();
            }
            return ic.getMethod().getAnnotation(Name.class).value();
        }
        return requiredPermission.operation();
    }

    private SecurityContext getSecurityContext() {
        return Beans.getReference(SecurityContext.class);
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return bundle;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = Beans.getReference(Logger.class, new NameQualifier(RequiredPermissionInterceptor.class.getName()));
        }
        return logger;
    }
}

