/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.implementation.StrategySelector;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.message.DefaultMessage;
import br.gov.frameworkdemoiselle.message.Message;
import br.gov.frameworkdemoiselle.message.MessageAppender;
import br.gov.frameworkdemoiselle.message.MessageContext;
import br.gov.frameworkdemoiselle.message.SeverityType;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;

public class MessageContextImpl
implements Serializable,
MessageContext {
    private static final long serialVersionUID = 1L;
    private transient ResourceBundle bundle;
    private transient Logger logger;

    @Override
    @Deprecated
    public void add(Message message, Object ... params) {
        this.getLogger().debug(this.getBundle().getString("adding-message-to-context", message.toString()));
        if (params == null || params.length == 0) {
            this.getAppender().append(message, new Object[0]);
        } else {
            this.getLogger().warn("Atualmente, ao chamar o m\u00e9todo add do MessageContext passando um objeto do tipo Message e mais par\u00e2metros, ser\u00e1 recriando um objeto\n Message, na implementa\u00e7\u00e3o DefaultMessage para que os par\u00e2metros sejam utilizados. Note que isso poder\u00e1 trazer problemas para sua aplica\u00e7\u00e3o, caso\n a implementa\u00e7\u00e3o de Message utilizada n\u00e3o seja a DefaultMessage. Para evitar esse tipo de problema e garantir compatibilidade com vers\u00f5es futuras, recomendamos que\n o objeto message seja criado com os par\u00e2metros, e que para o m\u00e9todo add apenas seja passado esse objeto como par\u00e2metro.");
            this.getAppender().append(new DefaultMessage(message.getText(), message.getSeverity(), params), new Object[0]);
        }
    }

    private MessageAppender getAppender() {
        Class<MessageAppender> appenderClass = StrategySelector.selectClass(MessageAppender.class);
        return Beans.getReference(appenderClass);
    }

    @Override
    public void add(String text, Object ... params) {
        this.add(text, null, params);
    }

    @Override
    public void add(String text, SeverityType severity, Object ... params) {
        this.add(new DefaultMessage(text, severity, params), new Object[0]);
    }

    @Override
    @Deprecated
    public List<Message> getMessages() {
        throw new DemoiselleException("Este m\u00e9todo n\u00e3o \u00e9 mais suportado desde a vers\u00e3o 2.4.0 do Demoiselle Framework. Considere atualizar a sua aplica\u00e7\u00e3o ou o componente com uma nova vers\u00e3o que fa\u00e7a uso do " + MessageAppender.class.getCanonicalName() + ".");
    }

    @Override
    @Deprecated
    public void clear() {
        throw new DemoiselleException("Este m\u00e9todo n\u00e3o \u00e9 mais suportado desde a vers\u00e3o 2.4.0 do Demoiselle Framework. Considere atualizar a sua aplica\u00e7\u00e3o ou o componente com uma nova vers\u00e3o que fa\u00e7a uso do " + MessageAppender.class.getCanonicalName() + ".");
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerProducer.create(MessageContext.class);
        }
        return this.logger;
    }
}

