/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.context.CustomContext;
import br.gov.frameworkdemoiselle.internal.bootstrap.CustomContextBootstrap;
import br.gov.frameworkdemoiselle.internal.context.BeanStore;
import br.gov.frameworkdemoiselle.internal.context.ContextualStore;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.Locale;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.slf4j.Logger;

public abstract class AbstractCustomContext
implements CustomContext {
    private boolean active;
    private final Class<? extends Annotation> scope;
    private transient Logger logger;
    private transient ResourceBundle bundle;

    protected AbstractCustomContext(Class<? extends Annotation> scope) {
        this.scope = scope;
        this.active = false;
    }

    protected abstract BeanStore getStore();

    protected abstract boolean isStoreInitialized();

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Object instance = null;
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        String id = this.getContextualStore().putIfAbsentAndGetId(contextual);
        BeanStore store = this.getStore();
        if (store != null) {
            if (store.contains(id)) {
                instance = store.getInstance(id);
            } else if (creationalContext != null) {
                instance = contextual.create(creationalContext);
                store.put(id, instance, creationalContext);
            }
        } else {
            throw new DemoiselleException(this.getBundle().getString("store-not-found", ((Bean)contextual).getBeanClass().getName(), this.getScope().getName()));
        }
        return (T)instance;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean activate() {
        boolean success = false;
        if (!this.active) {
            BeanManager beanManager = Beans.getBeanManager();
            if (beanManager != null) {
                try {
                    Context ctx = beanManager.getContext(this.getScope());
                    if (ctx != null) {
                        this.getLogger().debug(this.getBundle().getString("custom-context-already-activated", this.getClass().getCanonicalName(), this.getScope().getSimpleName(), ctx.getClass().getCanonicalName()));
                    }
                }
                catch (ContextNotActiveException ce) {
                    this.active = true;
                    success = true;
                    this.getLogger().debug(this.getBundle().getString("custom-context-was-activated", this.getClass().getCanonicalName(), this.getScope().getSimpleName()));
                }
            } else {
                this.active = true;
                success = true;
                this.getLogger().debug(this.getBundle().getString("custom-context-was-activated", this.getClass().getCanonicalName(), this.getScope().getSimpleName()));
            }
        }
        return success;
    }

    @Override
    public void deactivate() {
        if (this.active) {
            if (this.isStoreInitialized()) {
                this.clearInstances();
                this.getStore().clear();
                this.getContextualStore().clear();
            }
            this.active = false;
            Logger logger = this.getLogger();
            ResourceBundle bundle = this.getBundle();
            logger.debug(bundle.getString("custom-context-was-deactivated", this.getClass().getCanonicalName(), this.getScope().getSimpleName()));
        }
    }

    public void clearInstances() {
        BeanStore store = this.getStore();
        if (store != null) {
            for (String id : store) {
                Contextual contextual = this.getContextualStore().getContextual(id);
                Object instance = store.getInstance(id);
                CreationalContext creationalContext = store.getCreationalContext(id);
                if (contextual == null || instance == null) continue;
                contextual.destroy(instance, creationalContext);
            }
        }
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    protected static BeanStore createStore() {
        return new BeanStore();
    }

    protected static ContextualStore createContextualStore() {
        return new ContextualStore();
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = new ResourceBundle("demoiselle-core-bundle", Locale.getDefault());
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerProducer.create(this.getClass());
        }
        return this.logger;
    }

    protected ContextualStore getContextualStore() {
        CustomContextBootstrap bootstrap = Beans.getReference(CustomContextBootstrap.class);
        return bootstrap.getContextualStore();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractCustomContext other = (AbstractCustomContext)obj;
        return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
    }
}

