/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Ignore;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.configuration.ConfigType;
import br.gov.frameworkdemoiselle.configuration.ConfigurationException;
import br.gov.frameworkdemoiselle.configuration.ConfigurationValueExtractor;
import br.gov.frameworkdemoiselle.internal.bootstrap.ConfigurationBootstrap;
import br.gov.frameworkdemoiselle.internal.implementation.StrategySelector;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.Reflections;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import br.gov.frameworkdemoiselle.util.Strings;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.slf4j.Logger;

public class ConfigurationLoader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ResourceBundle bundle;
    private Logger logger;
    private Object object;
    private ConfigType type;
    private String resource;
    private String prefix;
    private Configuration configuration;
    private Collection<Field> fields;

    public void load(Object object) throws ConfigurationException {
        this.load(object, true);
    }

    public void load(Object object, boolean logLoadingProcess) throws ConfigurationException {
        if (logLoadingProcess) {
            this.getLogger().debug(this.getBundle().getString("loading-configuration-class", object.getClass().getName()));
        }
        this.object = object;
        this.loadFields();
        this.validateFields();
        this.loadType();
        this.loadResource();
        this.loadConfiguration();
        if (this.configuration != null) {
            this.loadPrefix();
            this.loadValues();
        }
        this.validateValues();
    }

    private void loadFields() {
        this.fields = Reflections.getNonStaticFields(this.object.getClass());
    }

    private void validateFields() {
        for (Field field : this.fields) {
            this.validateField(field);
        }
    }

    private void validateField(Field field) {
        Name annotation = field.getAnnotation(Name.class);
        if (annotation != null && Strings.isEmpty(annotation.value())) {
            throw new ConfigurationException(this.getBundle().getString("configuration-name-attribute-cant-be-empty"), new IllegalArgumentException());
        }
    }

    private void loadType() {
        this.type = this.object.getClass().getAnnotation(br.gov.frameworkdemoiselle.configuration.Configuration.class).type();
    }

    private void loadResource() {
        if (this.type != ConfigType.SYSTEM) {
            String name = this.object.getClass().getAnnotation(br.gov.frameworkdemoiselle.configuration.Configuration.class).resource();
            String extension = this.type.toString().toLowerCase();
            this.resource = name + "." + extension;
        }
    }

    private void loadConfiguration() {
        Configuration config = this.createConfiguration();
        if (config instanceof FileConfiguration) {
            ((FileConfiguration)config).setURL(Reflections.getResourceAsURL(this.resource));
            try {
                ((FileConfiguration)config).load();
            }
            catch (org.apache.commons.configuration.ConfigurationException cause) {
                this.getLogger().warn(this.getBundle().getString("file-not-found", this.resource));
                config = null;
            }
        }
        this.configuration = config;
    }

    private Configuration createConfiguration() {
        XMLConfiguration config;
        switch (this.type) {
            case XML: {
                config = new XMLConfiguration();
                break;
            }
            case SYSTEM: {
                config = new SystemConfiguration();
                break;
            }
            default: {
                config = new PropertiesConfiguration();
            }
        }
        config.setDelimiterParsingDisabled(true);
        return config;
    }

    private void loadPrefix() {
        String prefix = this.object.getClass().getAnnotation(br.gov.frameworkdemoiselle.configuration.Configuration.class).prefix();
        if (prefix.endsWith(".")) {
            this.getLogger().warn(this.getBundle().getString("configuration-dot-after-prefix", this.resource));
        } else if (!prefix.isEmpty()) {
            prefix = prefix + ".";
        }
        this.prefix = prefix;
    }

    private void loadValues() {
        for (Field field : this.fields) {
            this.loadValue(field);
        }
    }

    private void loadValue(Field field) {
        Object finalValue;
        if (this.hasIgnore(field)) {
            return;
        }
        Object defaultValue = Reflections.getFieldValue(field, this.object);
        Object loadedValue = this.getValue(field, field.getType(), this.getKey(field), defaultValue);
        Object object = finalValue = loadedValue == null ? defaultValue : loadedValue;
        if (loadedValue == null) {
            this.getLogger().debug(this.getBundle().getString("configuration-key-not-found", this.prefix + this.getKey(field)));
        }
        Reflections.setFieldValue(field, this.object, finalValue);
        this.getLogger().debug(this.getBundle().getString("configuration-field-loaded", this.prefix + this.getKey(field), field.getName(), finalValue == null ? "null" : finalValue));
    }

    private Object getValue(Field field, Class<?> type, String key, Object defaultValue) {
        Object value = null;
        try {
            ConfigurationValueExtractor extractor = this.getValueExtractor(field);
            value = extractor.getValue(this.prefix, key, field, this.configuration);
        }
        catch (ConfigurationException cause) {
            throw cause;
        }
        catch (ConversionException cause) {
            throw new ConfigurationException(this.getBundle().getString("configuration-not-conversion", this.prefix + this.getKey(field), field.getType().toString()), cause);
        }
        catch (Exception cause) {
            throw new ConfigurationException(this.getBundle().getString("configuration-generic-extraction-error", field.getType().toString(), this.getValueExtractor(field).getClass().getCanonicalName()), cause);
        }
        return value;
    }

    private ConfigurationValueExtractor getValueExtractor(Field field) {
        HashSet<ConfigurationValueExtractor> candidates = new HashSet<ConfigurationValueExtractor>();
        ConfigurationBootstrap bootstrap = Beans.getReference(ConfigurationBootstrap.class);
        for (Class extractorClass : bootstrap.getCache()) {
            ConfigurationValueExtractor extractor = (ConfigurationValueExtractor)Beans.getReference(extractorClass);
            if (!extractor.isSupported(field)) continue;
            candidates.add(extractor);
        }
        ConfigurationValueExtractor elected = StrategySelector.selectInstance(ConfigurationValueExtractor.class, candidates);
        if (elected == null) {
            throw new ConfigurationException(this.getBundle().getString("configuration-extractor-not-found", field.toGenericString(), ConfigurationValueExtractor.class.getName()), new ClassNotFoundException());
        }
        return elected;
    }

    private String getKey(Field field) {
        String key = field.isAnnotationPresent(Name.class) ? field.getAnnotation(Name.class).value() : field.getName();
        return key;
    }

    private boolean hasIgnore(Field field) {
        return field.isAnnotationPresent(Ignore.class);
    }

    private void validateValues() {
        for (Field field : this.fields) {
            this.validateValue(field, Reflections.getFieldValue(field, this.object));
        }
    }

    private void validateValue(Field field, Object value) {
        ValidatorFactory dfv = Validation.buildDefaultValidatorFactory();
        Validator validator = dfv.getValidator();
        Set violations = validator.validateProperty(this.object, field.getName(), new Class[0]);
        StringBuffer message = new StringBuffer();
        if (!violations.isEmpty()) {
            for (ConstraintViolation violation : violations) {
                message.append(field.toGenericString() + " " + violation.getMessage() + "\n");
            }
            throw new ConfigurationException(message.toString(), new ConstraintViolationException(violations));
        }
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Beans.getReference(Logger.class, new NameQualifier(ConfigurationLoader.class.getName()));
        }
        return this.logger;
    }
}

