/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import br.gov.frameworkdemoiselle.context.ConversationContext;
import br.gov.frameworkdemoiselle.context.CustomContext;
import br.gov.frameworkdemoiselle.context.RequestContext;
import br.gov.frameworkdemoiselle.context.SessionContext;
import br.gov.frameworkdemoiselle.context.StaticContext;
import br.gov.frameworkdemoiselle.context.ViewContext;
import br.gov.frameworkdemoiselle.internal.bootstrap.CustomContextBootstrap;
import br.gov.frameworkdemoiselle.internal.implementation.StrategySelector;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.slf4j.Logger;

@ApplicationScoped
public class CustomContextProducer {
    private Logger logger;
    private transient ResourceBundle bundle;

    public void addRegisteredContext(CustomContext context) {
        Logger logger = this.getLogger();
        ResourceBundle bundle = this.getBundle();
        if (!this.getContexts().contains(context)) {
            this.getContexts().add(context);
            logger.debug(bundle.getString("bootstrap-context-added", context.getClass().getCanonicalName(), context.getScope().getSimpleName()));
        } else {
            logger.warn(bundle.getString("bootstrap-context-already-managed", context.getClass().getCanonicalName(), context.getScope().getSimpleName()));
        }
    }

    @PreDestroy
    public void closeContexts() {
        for (CustomContext context : this.getContexts()) {
            context.deactivate();
        }
        this.getContexts().clear();
    }

    private List<CustomContext> getContexts() {
        CustomContextBootstrap contextBootstrap = Beans.getReference(CustomContextBootstrap.class);
        return contextBootstrap.getCustomContexts();
    }

    @Produces
    protected RequestContext getRequestContext(InjectionPoint ip) {
        if (ip != null) {
            return (RequestContext)this.getContext(ip);
        }
        return this.getContext(RequestContext.class);
    }

    @Produces
    protected SessionContext getSessionContext(InjectionPoint ip) {
        if (ip != null) {
            return (SessionContext)this.getContext(ip);
        }
        return this.getContext(SessionContext.class);
    }

    @Produces
    protected ViewContext getViewContext(InjectionPoint ip) {
        if (ip != null) {
            return (ViewContext)this.getContext(ip);
        }
        return this.getContext(ViewContext.class);
    }

    @Produces
    protected StaticContext getStaticContext(InjectionPoint ip) {
        if (ip != null) {
            return (StaticContext)this.getContext(ip);
        }
        return this.getContext(StaticContext.class);
    }

    @Produces
    protected ConversationContext getConversationContext(InjectionPoint ip) {
        if (ip != null) {
            return (ConversationContext)this.getContext(ip);
        }
        return this.getContext(ConversationContext.class);
    }

    public <T extends CustomContext> T getContext(InjectionPoint ip) {
        Object producedContext = null;
        if (ip != null) {
            Class beanClass = (Class)ip.getType();
            producedContext = this.getContext(beanClass);
        }
        if (producedContext != null) {
            this.getLogger().debug(this.getBundle().getString("custom-context-selected", producedContext.getClass().getCanonicalName()));
        }
        return (T)producedContext;
    }

    public <T extends CustomContext> T getContext(Class<T> contextClass) {
        CustomContext producedContext = null;
        ArrayList<CustomContext> selectableContexts = new ArrayList<CustomContext>();
        for (CustomContext context : this.getContexts()) {
            if (!contextClass.isAssignableFrom(context.getClass())) continue;
            if (context.isActive()) {
                producedContext = context;
                break;
            }
            selectableContexts.add(context);
        }
        if (producedContext == null && !selectableContexts.isEmpty()) {
            producedContext = StrategySelector.selectInstance(CustomContext.class, selectableContexts);
        }
        return (T)producedContext;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerProducer.create(this.getClass());
        }
        return this.logger;
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = new ResourceBundle("demoiselle-core-bundle", Locale.getDefault());
        }
        return this.bundle;
    }
}

