/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.exception;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.exception.ExceptionHandler;
import br.gov.frameworkdemoiselle.stereotype.Controller;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

@Interceptor
@Controller
public class ExceptionHandlerInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ResourceBundle bundle;
    private transient Logger logger;
    private final Map<Class<?>, Map<Class<?>, Method>> cache = new HashMap();

    private boolean handleException(Exception cause, Object target) throws Exception {
        Method handler;
        this.getLogger().info(this.getBundle().getString("handling-exception", cause.getClass().getCanonicalName()));
        boolean handled = false;
        Class<?> type = target.getClass();
        if (!this.isLoaded(type)) {
            this.loadHandlers(type);
        }
        if ((handler = this.getMethod(type, cause.getClass())) != null) {
            this.invoke(handler, target, cause);
            handled = true;
        }
        return handled;
    }

    private Method getMethod(Class<?> type, Class<?> causeClass) {
        Method handler = null;
        Map<Class<?>, Method> map = this.cache.get(type);
        if (map != null && Throwable.class.isAssignableFrom(causeClass)) {
            handler = map.containsKey(causeClass) ? map.get(causeClass) : this.getMethod(type, causeClass.getSuperclass());
        }
        return handler;
    }

    private void loadHandlers(Class<?> type) {
        HashMap mapHandlers = new HashMap();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> tempType = type; tempType != null; tempType = tempType.getSuperclass()) {
            methods.addAll(Arrays.asList(tempType.getMethods()));
        }
        for (Method method : methods) {
            if (!method.isAnnotationPresent(ExceptionHandler.class)) continue;
            this.validateHandler(method);
            mapHandlers.put(method.getParameterTypes()[0], method);
        }
        this.cache.put(type, mapHandlers);
    }

    private void validateHandler(Method method) {
        if (method.getParameterTypes().length != 1) {
            throw new DemoiselleException(this.getBundle().getString("must-declare-one-single-parameter", method.toGenericString()));
        }
    }

    private boolean isLoaded(Class<?> type) {
        return this.cache.containsKey(type);
    }

    private void invoke(Method method, Object object, Exception param) throws Exception {
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        try {
            method.invoke(object, param);
        }
        catch (InvocationTargetException cause) {
            Throwable targetTrowable = cause.getTargetException();
            if (targetTrowable instanceof Exception) {
                throw (Exception)targetTrowable;
            }
            throw new Exception(targetTrowable);
        }
        method.setAccessible(accessible);
    }

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        Object result;
        block2: {
            result = null;
            Object target = ic.getTarget();
            try {
                result = ic.proceed();
            }
            catch (Exception cause) {
                if (this.handleException(cause, target)) break block2;
                throw cause;
            }
        }
        return result;
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Beans.getReference(Logger.class, new NameQualifier(ExceptionHandlerInterceptor.class.getName()));
        }
        return this.logger;
    }
}

