/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;

public final class Beans {
    private static transient ResourceBundle bundle;
    private static BeanManager manager;

    private Beans() {
    }

    public static void setBeanManager(BeanManager beanManager) {
        manager = beanManager;
    }

    public static BeanManager getBeanManager() {
        return manager;
    }

    public static <T> T getReference(Class<T> beanClass, Annotation ... qualifiers) {
        T instance;
        try {
            instance = Beans.getReference(manager.getBeans(beanClass, qualifiers), beanClass, qualifiers);
        }
        catch (NoSuchElementException cause) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(beanClass.getCanonicalName());
            for (Annotation qualifier : qualifiers) {
                buffer.append(", ");
                buffer.append(qualifier.getClass().getCanonicalName());
            }
            String message = Beans.getBundle().getString("bean-not-found", buffer.toString());
            throw new DemoiselleException(message, cause);
        }
        return instance;
    }

    public static <T> T getReference(Class<T> beanClass) {
        T instance;
        try {
            instance = Beans.getReference(manager.getBeans(beanClass, new Annotation[0]), beanClass, new Annotation[0]);
        }
        catch (NoSuchElementException cause) {
            String message = Beans.getBundle().getString("bean-not-found", beanClass.getCanonicalName());
            throw new DemoiselleException(message, cause);
        }
        return instance;
    }

    public static <T> T getReference(String beanName) {
        T instance;
        try {
            instance = Beans.getReference(manager.getBeans(beanName));
        }
        catch (NoSuchElementException cause) {
            String message = Beans.getBundle().getString("bean-not-found", beanName);
            throw new DemoiselleException(message, cause);
        }
        return instance;
    }

    private static <T> T getReference(Set<Bean<?>> beans, Class<T> beanClass, Annotation ... qualifiers) {
        Bean<?> bean = beans.iterator().next();
        CreationalContext context = manager.createCreationalContext(bean);
        Class beanType = beanClass == null ? bean.getBeanClass() : beanClass;
        CustomInjectionPoint injectionPoint = new CustomInjectionPoint(bean, beanType, qualifiers);
        return (T)manager.getInjectableReference((InjectionPoint)injectionPoint, context);
    }

    private static <T> T getReference(Set<Bean<?>> beans) {
        return Beans.getReference(beans, (Class)null, new Annotation[0]);
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return bundle;
    }

    static class CustomInjectionPoint
    implements InjectionPoint {
        private final Bean<?> bean;
        private final Type beanType;
        private final Set<Annotation> qualifiers;

        public CustomInjectionPoint(Bean<?> bean, Type beanType, Annotation ... qualifiers) {
            this.bean = bean;
            this.beanType = beanType;
            this.qualifiers = new HashSet<Annotation>(Arrays.asList(qualifiers));
        }

        public Type getType() {
            return this.beanType;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Bean<?> getBean() {
            return this.bean;
        }

        public Member getMember() {
            return null;
        }

        public boolean isDelegate() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }

        public Annotated getAnnotated() {
            return new Annotated(){

                public Type getBaseType() {
                    return null;
                }

                public Set<Type> getTypeClosure() {
                    return null;
                }

                public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                    Annotation result = null;
                    for (Annotation annotation : this.getAnnotations()) {
                        if (annotation.annotationType() != annotationType) continue;
                        result = annotation;
                        break;
                    }
                    return (T)result;
                }

                public Set<Annotation> getAnnotations() {
                    return CustomInjectionPoint.this.qualifiers;
                }

                public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                    return CustomInjectionPoint.this.qualifiers.contains(annotationType);
                }
            };
        }
    }
}

