/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.transaction;

import br.gov.frameworkdemoiselle.exception.ApplicationException;
import br.gov.frameworkdemoiselle.transaction.Transaction;
import br.gov.frameworkdemoiselle.transaction.TransactionContext;
import br.gov.frameworkdemoiselle.transaction.Transactional;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

@Interceptor
@Transactional
public class TransactionalInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TransactionContext transactionContext;
    private TransactionInfo transactionInfo;
    private static transient ResourceBundle bundle;
    private static transient Logger logger;

    private TransactionContext getTransactionContext() {
        if (this.transactionContext == null) {
            this.transactionContext = Beans.getReference(TransactionContext.class);
        }
        return this.transactionContext;
    }

    private TransactionInfo newTransactionInfo() {
        TransactionInfo instance;
        try {
            instance = Beans.getReference(TransactionInfo.class);
            instance.getCounter();
        }
        catch (ContextNotActiveException cause) {
            instance = new VoidTransactionInfo();
        }
        return instance;
    }

    private TransactionInfo getTransactionInfo() {
        if (this.transactionInfo == null) {
            this.transactionInfo = this.newTransactionInfo();
        }
        return this.transactionInfo;
    }

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        this.initiate();
        Object result = null;
        try {
            TransactionalInterceptor.getLogger().debug(TransactionalInterceptor.getBundle().getString("transactional-execution", ic.getMethod().toGenericString()));
            result = ic.proceed();
        }
        catch (Exception cause) {
            this.handleException(cause);
            throw cause;
        }
        finally {
            this.complete();
        }
        return result;
    }

    private void initiate() {
        Transaction transaction = this.getTransactionContext().getCurrentTransaction();
        if (!transaction.isActive()) {
            transaction.begin();
            this.getTransactionInfo().markAsOwner();
            TransactionalInterceptor.getLogger().info(TransactionalInterceptor.getBundle().getString("begin-transaction"));
        }
        this.getTransactionInfo().incrementCounter();
    }

    private void handleException(Exception cause) {
        Transaction transaction = this.getTransactionContext().getCurrentTransaction();
        if (!transaction.isMarkedRollback()) {
            boolean rollback = false;
            ApplicationException annotation = cause.getClass().getAnnotation(ApplicationException.class);
            if (annotation == null || annotation.rollback()) {
                rollback = true;
            }
            if (rollback) {
                transaction.setRollbackOnly();
                TransactionalInterceptor.getLogger().info(TransactionalInterceptor.getBundle().getString("transaction-marked-rollback", cause.getMessage()));
            }
        }
    }

    private void complete() {
        Transaction transaction = this.getTransactionContext().getCurrentTransaction();
        this.getTransactionInfo().decrementCounter();
        if (this.getTransactionInfo().getCounter() == 0 && transaction.isActive()) {
            if (this.getTransactionInfo().isOwner()) {
                if (transaction.isMarkedRollback()) {
                    transaction.rollback();
                    this.getTransactionInfo().clear();
                    TransactionalInterceptor.getLogger().info(TransactionalInterceptor.getBundle().getString("transaction-rolledback"));
                } else {
                    transaction.commit();
                    this.getTransactionInfo().clear();
                    TransactionalInterceptor.getLogger().info(TransactionalInterceptor.getBundle().getString("transaction-commited"));
                }
            }
        } else if (this.getTransactionInfo().getCounter() == 0 && !transaction.isActive()) {
            TransactionalInterceptor.getLogger().info(TransactionalInterceptor.getBundle().getString("transaction-already-finalized"));
        }
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return bundle;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = Beans.getReference(Logger.class, new NameQualifier(TransactionalInterceptor.class.getName()));
        }
        return logger;
    }

    @Any
    static class VoidTransactionInfo
    extends TransactionInfo {
        private static final long serialVersionUID = 1L;

        VoidTransactionInfo() {
        }

        @Override
        public boolean isOwner() {
            return false;
        }
    }

    @RequestScoped
    static class TransactionInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int counter = 0;
        private boolean owner;

        public TransactionInfo() {
            this.clear();
        }

        public void clear() {
            this.owner = false;
            this.counter = 0;
        }

        public int getCounter() {
            return this.counter;
        }

        public void incrementCounter() {
            ++this.counter;
        }

        public void decrementCounter() {
            --this.counter;
        }

        public void markAsOwner() {
            this.owner = true;
        }

        public boolean isOwner() {
            return this.owner;
        }
    }
}

