/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.pagination.Pagination;
import br.gov.frameworkdemoiselle.util.Strings;
import java.io.Serializable;

public class PaginationImpl
implements Serializable,
Pagination {
    private static final long serialVersionUID = 1L;
    private int currentPage;
    private int pageSize = 0;
    private int totalResults = 0;
    private int totalPages;

    public PaginationImpl() {
        this.reset();
    }

    private void reset() {
        this.currentPage = 0;
        this.totalPages = 0;
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    private void setTotalPages(int totalPages) {
        this.validateNegativeValue(totalPages);
        this.totalPages = totalPages;
        if (totalPages == 0) {
            this.reset();
        } else if (this.getCurrentPage() >= totalPages) {
            this.setCurrentPage(totalPages - 1);
        }
    }

    private void validateNegativeValue(int input) throws IndexOutOfBoundsException {
        if (input < 0) {
            throw new IndexOutOfBoundsException("colocar mensagem");
        }
    }

    private void validateCurrentPage(int currentPage) throws IndexOutOfBoundsException {
        if (currentPage >= this.totalPages && this.totalPages > 0) {
            throw new IndexOutOfBoundsException("colocar mensagem");
        }
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.validateNegativeValue(currentPage);
        this.validateCurrentPage(currentPage);
        this.currentPage = currentPage;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getTotalResults() {
        return this.totalResults;
    }

    @Override
    public void setTotalResults(int totalResults) {
        this.validateNegativeValue(totalResults);
        this.totalResults = totalResults;
        if (totalResults > 0) {
            this.setTotalPages();
        } else {
            this.reset();
        }
    }

    private void setTotalPages() {
        if (this.totalResults > 0) {
            this.setTotalPages((int)Math.ceil((double)this.totalResults * 1.0 / (double)this.getPageSize()));
        } else {
            this.setTotalPages(0);
        }
    }

    @Override
    public int getTotalPages() {
        return this.totalPages;
    }

    @Override
    public int getFirstResult() {
        return this.getCurrentPage() * this.getPageSize();
    }

    @Override
    public void setPageSize(int pageSize) {
        this.validateNegativeValue(pageSize);
        this.pageSize = pageSize;
        if (pageSize > 0) {
            this.setTotalPages();
        } else {
            this.reset();
        }
    }

    private void validateFirstResult(int firstResult) throws IndexOutOfBoundsException {
        if (firstResult >= this.totalResults && this.totalResults > 0) {
            throw new IndexOutOfBoundsException("colocar mensagem");
        }
    }

    @Override
    public void setFirstResult(int firstResult) {
        this.validateNegativeValue(firstResult);
        this.validateFirstResult(firstResult);
        if (firstResult > 0) {
            this.setCurrentPage(firstResult / this.pageSize);
        } else {
            this.setCurrentPage(0);
        }
    }

    public String toString() {
        return Strings.toString(this);
    }
}

