/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.implementation.StrategySelector;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.message.DefaultMessage;
import br.gov.frameworkdemoiselle.message.Message;
import br.gov.frameworkdemoiselle.message.MessageAppender;
import br.gov.frameworkdemoiselle.message.MessageContext;
import br.gov.frameworkdemoiselle.message.SeverityType;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;

public class MessageContextImpl
implements Serializable,
MessageContext {
    private static final long serialVersionUID = 1L;
    private static transient ResourceBundle bundle;
    private static transient Logger logger;

    @Override
    public void add(Message message, Object ... params) {
        Message aux = params != null ? new DefaultMessage(message.getText(), message.getSeverity(), params) : message;
        MessageContextImpl.getLogger().debug(MessageContextImpl.getBundle().getString("adding-message-to-context", message.toString()));
        this.getAppender().append(aux);
    }

    private MessageAppender getAppender() {
        Class<MessageAppender> appenderClass = StrategySelector.selectClass(MessageAppender.class);
        return Beans.getReference(appenderClass);
    }

    @Override
    public void add(String text, Object ... params) {
        this.add(text, null, params);
    }

    @Override
    public void add(String text, SeverityType severity, Object ... params) {
        this.add(new DefaultMessage(text, severity, params), new Object[0]);
    }

    @Override
    @Deprecated
    public List<Message> getMessages() {
        throw new DemoiselleException("Este m\u00e9todo n\u00e3o \u00e9 mais suportado desde a vers\u00e3o 2.4.0 do Demoiselle Framework. Considere atualizar a sua aplica\u00e7\u00e3o ou o componente com uma nova vers\u00e3o que fa\u00e7a uso do " + MessageAppender.class.getCanonicalName() + ".");
    }

    @Override
    @Deprecated
    public void clear() {
        throw new DemoiselleException("Este m\u00e9todo n\u00e3o \u00e9 mais suportado desde a vers\u00e3o 2.4.0 do Demoiselle Framework. Considere atualizar a sua aplica\u00e7\u00e3o ou o componente com uma nova vers\u00e3o que fa\u00e7a uso do " + MessageAppender.class.getCanonicalName() + ".");
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return bundle;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerProducer.create(MessageContext.class);
        }
        return logger;
    }
}

