/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import br.gov.frameworkdemoiselle.internal.context.ContextManager;
import br.gov.frameworkdemoiselle.internal.context.CustomContext;
import br.gov.frameworkdemoiselle.util.Beans;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.BeanManager;

class CustomContextCounter {
    private CustomContext context;
    private int activationCounter = 0;

    public CustomContextCounter(CustomContext customContext) {
        this.context = customContext;
    }

    public boolean isSame(Class<? extends CustomContext> customContextClass, Class<? extends Annotation> scope) {
        return this.context.getClass().getCanonicalName().equals(customContextClass.getCanonicalName()) && this.context.getScope().equals(scope);
    }

    public CustomContext getInternalContext() {
        return this.context;
    }

    public void setInternalContext(CustomContext context) {
        this.context = context;
    }

    public synchronized void activate() {
        try {
            BeanManager beanManager = Beans.getReference(BeanManager.class);
            Context c = beanManager.getContext(this.context.getScope());
            if (c == this.context) {
                ++this.activationCounter;
            } else {
                ContextManager.getLogger().trace(ContextManager.getBundle().getString("custom-context-already-activated", this.context.getClass().getCanonicalName(), c.getScope().getCanonicalName(), c.getClass().getCanonicalName()));
            }
        }
        catch (ContextNotActiveException ce) {
            this.context.setActive(true);
            ++this.activationCounter;
            ContextManager.getLogger().trace(ContextManager.getBundle().getString("custom-context-was-activated", this.context.getClass().getCanonicalName(), this.context.getScope().getCanonicalName()));
        }
    }

    public synchronized void deactivate() {
        try {
            Context c = Beans.getBeanManager().getContext(this.context.getScope());
            if (c == this.context) {
                --this.activationCounter;
                if (this.activationCounter == 0) {
                    this.context.setActive(false);
                    ContextManager.getLogger().trace(ContextManager.getBundle().getString("custom-context-was-deactivated", this.context.getClass().getCanonicalName(), this.context.getScope().getCanonicalName()));
                }
            }
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
    }

    public synchronized void shutdown() {
        this.context.setActive(false);
        this.context = null;
        this.activationCounter = 0;
    }
}

