/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.annotation.StaticScoped;
import br.gov.frameworkdemoiselle.internal.context.ContextManager;
import br.gov.frameworkdemoiselle.internal.context.StaticContext;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.util.Locale;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import org.slf4j.Logger;

public class CoreBootstrap
implements Extension {
    private Logger logger;
    private static transient ResourceBundle bundle;

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerProducer.create(CoreBootstrap.class);
        }
        return this.logger;
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = new ResourceBundle("demoiselle-core-bundle", Locale.getDefault());
        }
        return bundle;
    }

    public void engineOn(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        this.getLogger().info(CoreBootstrap.getBundle().getString("engine-on"));
        Beans.setBeanManager(beanManager);
        this.getLogger().info(CoreBootstrap.getBundle().getString("setting-up-bean-manager", Beans.class.getCanonicalName()));
    }

    public void initializeCustomContexts(@Observes AfterBeanDiscovery event) {
        ContextManager.initialize(event);
        ContextManager.activate(StaticContext.class, StaticScoped.class);
    }

    public void terminateCustomContexts(@Observes BeforeShutdown event) {
        ContextManager.shutdown();
    }

    public void takeOff(@Observes AfterDeploymentValidation event) {
        this.getLogger().info(CoreBootstrap.getBundle().getString("taking-off"));
    }

    public void engineOff(@Observes BeforeShutdown event) {
        this.getLogger().info(CoreBootstrap.getBundle().getString("engine-off"));
    }
}

