/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.ViewScoped;
import br.gov.frameworkdemoiselle.internal.context.ContextManager;
import br.gov.frameworkdemoiselle.internal.context.ThreadLocalContext;
import br.gov.frameworkdemoiselle.internal.implementation.AnnotatedMethodProcessor;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.Reflections;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.slf4j.Logger;

public abstract class AbstractLifecycleBootstrap<A extends Annotation>
implements Extension {
    private Class<A> annotationClass;
    private List<AnnotatedMethodProcessor> processors = Collections.synchronizedList(new ArrayList());
    private boolean registered = false;
    private static transient ResourceBundle bundle;

    protected abstract Logger getLogger();

    protected static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return bundle;
    }

    protected <T> AnnotatedMethodProcessor<T> newProcessorInstance(AnnotatedMethod<T> annotatedMethod) {
        return new AnnotatedMethodProcessor<T>(annotatedMethod);
    }

    protected Class<A> getAnnotationClass() {
        if (this.annotationClass == null) {
            this.annotationClass = Reflections.getGenericTypeArgument(this.getClass(), 0);
        }
        return this.annotationClass;
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        for (AnnotatedMethod am : annotatedType.getMethods()) {
            if (!am.isAnnotationPresent(this.getAnnotationClass())) continue;
            this.processors.add(this.newProcessorInstance(am));
        }
    }

    public void loadTempContexts(@Observes AfterBeanDiscovery event) {
        ContextManager.initialize(event);
        ContextManager.add(new ThreadLocalContext(ViewScoped.class), event);
        ContextManager.add(new ThreadLocalContext(SessionScoped.class), event);
        ContextManager.add(new ThreadLocalContext(ConversationScoped.class), event);
        ContextManager.add(new ThreadLocalContext(RequestScoped.class), event);
    }

    protected synchronized void proccessEvent() {
        this.getLogger().debug(AbstractLifecycleBootstrap.getBundle().getString("executing-all", this.getAnnotationClass().getSimpleName()));
        Collections.sort(this.processors);
        Exception failure = null;
        if (!this.registered) {
            ContextManager.activate(ThreadLocalContext.class, ViewScoped.class);
            ContextManager.activate(ThreadLocalContext.class, SessionScoped.class);
            ContextManager.activate(ThreadLocalContext.class, ConversationScoped.class);
            ContextManager.activate(ThreadLocalContext.class, RequestScoped.class);
            this.registered = true;
        }
        Iterator<AnnotatedMethodProcessor> iter = this.processors.iterator();
        while (iter.hasNext()) {
            AnnotatedMethodProcessor processor = iter.next();
            try {
                ClassLoader classLoader = Reflections.getClassLoaderForClass(processor.getAnnotatedMethod().getDeclaringType().getJavaClass().getCanonicalName());
                if (!Thread.currentThread().getContextClassLoader().equals(classLoader)) continue;
                processor.process(new Object[0]);
                iter.remove();
            }
            catch (Exception cause) {
                failure = cause;
            }
        }
        if (this.processors.isEmpty()) {
            ContextManager.deactivate(ThreadLocalContext.class, ViewScoped.class);
            ContextManager.deactivate(ThreadLocalContext.class, SessionScoped.class);
            ContextManager.deactivate(ThreadLocalContext.class, ConversationScoped.class);
            ContextManager.deactivate(ThreadLocalContext.class, RequestScoped.class);
        }
        if (failure != null) {
            throw new DemoiselleException(failure);
        }
    }
}

