/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.proxy.Slf4jLoggerProxy;
import br.gov.frameworkdemoiselle.util.Reflections;
import java.io.Serializable;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.slf4j.Logger;

public class LoggerProducer
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Default
    @Produces
    public Logger create(InjectionPoint ip) {
        Class type = ip.getMember() != null ? ip.getMember().getDeclaringClass() : LoggerProducer.class;
        return LoggerProducer.create(type);
    }

    @Name(value="")
    @Produces
    public Logger createNamed(InjectionPoint ip) throws ClassNotFoundException {
        Class type;
        try {
            String canonicalName = ((Name)ip.getAnnotated().getAnnotation(Name.class)).value();
            type = Reflections.forName(canonicalName);
        }
        catch (ClassCastException cause) {
            throw new DemoiselleException(null, cause);
        }
        return LoggerProducer.create(type);
    }

    public static <T> Logger create(Class<T> type) {
        return new Slf4jLoggerProxy(type);
    }
}

