/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.management;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.context.ContextManager;
import br.gov.frameworkdemoiselle.internal.context.ManagedContext;
import br.gov.frameworkdemoiselle.internal.management.ManagedType;
import br.gov.frameworkdemoiselle.lifecycle.ManagementExtension;
import br.gov.frameworkdemoiselle.management.AttributeChangeNotification;
import br.gov.frameworkdemoiselle.management.NotificationManager;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.slf4j.Logger;

@ApplicationScoped
public class Management {
    @Inject
    private Logger logger;
    @Inject
    @Name(value="demoiselle-core-bundle")
    private ResourceBundle bundle;
    private final List<ManagedType> managedTypes = new ArrayList<ManagedType>();
    private Validator validator;

    public void addManagedType(ManagedType managedType) {
        this.managedTypes.add(managedType);
        this.logger.debug(this.bundle.getString("management-debug-registering-managed-type", managedType.getType().getCanonicalName()));
    }

    public List<ManagedType> getManagedTypes() {
        ArrayList<ManagedType> cloneList = new ArrayList<ManagedType>();
        cloneList.addAll(this.managedTypes);
        return cloneList;
    }

    public Object invoke(ManagedType managedType, String actionName, Object[] params) {
        if (this.managedTypes.contains(managedType)) {
            this.activateContexts(managedType.getType());
            try {
                Object delegate = Beans.getReference(managedType.getType(), managedType.getQualifiers());
                ManagedType.MethodDetail method = managedType.getOperationMethods().get(actionName);
                if (method != null) {
                    try {
                        this.logger.debug(this.bundle.getString("management-debug-invoking-operation", actionName, managedType.getType().getCanonicalName()));
                        Object object = method.getMethod().invoke(delegate, params);
                        return object;
                    }
                    catch (Exception e) {
                        throw new DemoiselleException(this.bundle.getString("management-invoke-error", actionName), e);
                    }
                }
                throw new DemoiselleException(this.bundle.getString("management-invoke-error", actionName));
            }
            finally {
                this.deactivateContexts(managedType.getType());
            }
        }
        throw new DemoiselleException(this.bundle.getString("management-type-not-found"));
    }

    public Object getProperty(ManagedType managedType, String propertyName) {
        if (this.managedTypes.contains(managedType)) {
            Method getterMethod = managedType.getFields().get(propertyName).getGetterMethod();
            if (getterMethod != null) {
                this.logger.debug(this.bundle.getString("management-debug-acessing-property", getterMethod.getName(), managedType.getType().getCanonicalName()));
                this.activateContexts(managedType.getType());
                try {
                    Object delegate = Beans.getReference(managedType.getType(), managedType.getQualifiers());
                    Object object = getterMethod.invoke(delegate, (Object[])null);
                    return object;
                }
                catch (Exception e) {
                    throw new DemoiselleException(this.bundle.getString("management-invoke-error", getterMethod.getName()), e);
                }
                finally {
                    this.deactivateContexts(managedType.getType());
                }
            }
            throw new DemoiselleException(this.bundle.getString("management-read-value-error", propertyName));
        }
        throw new DemoiselleException(this.bundle.getString("management-type-not-found"));
    }

    public void setProperty(ManagedType managedType, String propertyName, Object newValue) {
        if (this.managedTypes.contains(managedType)) {
            Method method = managedType.getFields().get(propertyName).getSetterMethod();
            if (method != null) {
                this.logger.debug(this.bundle.getString("management-debug-setting-property", method.getName(), managedType.getType().getCanonicalName()));
                this.activateContexts(managedType.getType());
                try {
                    Object oldValue;
                    Object delegate = Beans.getReference(managedType.getType(), managedType.getQualifiers());
                    Validator validator = this.getDefaultValidator();
                    if (validator != null) {
                        Set violations = validator.validateValue(managedType.getType(), propertyName, newValue, new Class[0]);
                        if (violations.size() > 0) {
                            StringBuffer errorBuffer = new StringBuffer();
                            for (Object objectViolation : violations) {
                                ConstraintViolation violation = (ConstraintViolation)objectViolation;
                                errorBuffer.append(violation.getMessage()).append('\r').append('\n');
                            }
                            if (errorBuffer.length() > 0) {
                                errorBuffer.insert(0, "\r\n");
                                errorBuffer.insert(errorBuffer.length(), "\r\n");
                            }
                            throw new DemoiselleException(this.bundle.getString("management-validation-constraint-violation", managedType.getType().getCanonicalName(), propertyName, errorBuffer.toString()));
                        }
                    } else {
                        this.logger.warn(this.bundle.getString("management-validation-validator-not-found"));
                    }
                    Method getterMethod = managedType.getFields().get(propertyName).getGetterMethod();
                    try {
                        oldValue = getterMethod.invoke(delegate, (Object[])null);
                    }
                    catch (Exception e) {
                        oldValue = null;
                    }
                    method.invoke(delegate, newValue);
                    NotificationManager notificationManager = Beans.getReference(NotificationManager.class);
                    Class<?> attributeType = newValue != null ? newValue.getClass() : null;
                    AttributeChangeNotification notification = new AttributeChangeNotification(this.bundle.getString("management-notification-attribute-changed", propertyName, managedType.getType().getCanonicalName()), propertyName, attributeType, oldValue, newValue);
                    notificationManager.sendNotification(notification);
                }
                catch (DemoiselleException de) {
                    throw de;
                }
                catch (Exception e) {
                    throw new DemoiselleException(this.bundle.getString("management-invoke-error", method.getName()), e);
                }
                finally {
                    this.deactivateContexts(managedType.getType());
                }
            }
            throw new DemoiselleException(this.bundle.getString("management-write-value-error", propertyName));
        }
        throw new DemoiselleException(this.bundle.getString("management-type-not-found"));
    }

    private void activateContexts(Class<?> managedType) {
        this.logger.debug(this.bundle.getString("management-debug-starting-custom-context", ManagedContext.class.getCanonicalName(), managedType.getCanonicalName()));
        ContextManager.activate(ManagedContext.class, RequestScoped.class);
    }

    private void deactivateContexts(Class<?> managedType) {
        this.logger.debug(this.bundle.getString("management-debug-stoping-custom-context", ManagedContext.class.getCanonicalName(), managedType.getCanonicalName()));
        ContextManager.deactivate(ManagedContext.class, RequestScoped.class);
    }

    public void shutdown(Collection<Class<? extends ManagementExtension>> monitoringExtensions) {
        for (Class<? extends ManagementExtension> monitoringExtensionClass : monitoringExtensions) {
            ManagementExtension monitoringExtension = Beans.getReference(monitoringExtensionClass);
            monitoringExtension.shutdown(this.getManagedTypes());
            this.logger.debug(this.bundle.getString("management-debug-removing-management-extension", monitoringExtension.getClass().getCanonicalName()));
        }
    }

    public void initialize(Collection<Class<? extends ManagementExtension>> monitoringExtensions) {
        for (Class<? extends ManagementExtension> monitoringExtensionClass : monitoringExtensions) {
            ManagementExtension monitoringExtension = Beans.getReference(monitoringExtensionClass);
            this.logger.debug(this.bundle.getString("management-debug-processing-management-extension", monitoringExtension.getClass().getCanonicalName()));
            monitoringExtension.initialize(this.getManagedTypes());
        }
    }

    private Validator getDefaultValidator() {
        if (this.validator == null) {
            try {
                this.validator = Validation.buildDefaultValidatorFactory().getValidator();
            }
            catch (ValidationException e) {
                this.validator = null;
            }
        }
        return this.validator;
    }
}

