/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.configuration.SecurityConfig;
import br.gov.frameworkdemoiselle.internal.implementation.StrategySelector;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.security.AfterLoginSuccessful;
import br.gov.frameworkdemoiselle.security.AfterLogoutSuccessful;
import br.gov.frameworkdemoiselle.security.AuthenticationException;
import br.gov.frameworkdemoiselle.security.Authenticator;
import br.gov.frameworkdemoiselle.security.Authorizer;
import br.gov.frameworkdemoiselle.security.NotLoggedInException;
import br.gov.frameworkdemoiselle.security.SecurityContext;
import br.gov.frameworkdemoiselle.security.User;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.Principal;
import javax.inject.Named;

@Named(value="securityContext")
public class SecurityContextImpl
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private Authenticator authenticator;
    private Authorizer authorizer;

    private Authenticator getAuthenticator() {
        if (this.authenticator == null) {
            Class<? extends Authenticator> clazz = this.getConfig().getAuthenticatorClass();
            if (clazz == null) {
                clazz = StrategySelector.selectClass(Authenticator.class);
            }
            this.authenticator = Beans.getReference(clazz);
        }
        return this.authenticator;
    }

    private Authorizer getAuthorizer() {
        if (this.authorizer == null) {
            Class<? extends Authorizer> clazz = this.getConfig().getAuthorizerClass();
            if (clazz == null) {
                clazz = StrategySelector.selectClass(Authorizer.class);
            }
            this.authorizer = Beans.getReference(clazz);
        }
        return this.authorizer;
    }

    @Override
    public boolean hasPermission(String resource, String operation) throws NotLoggedInException {
        if (this.getConfig().isEnabled()) {
            this.checkLoggedIn();
            return this.getAuthorizer().hasPermission(resource, operation);
        }
        return true;
    }

    @Override
    public boolean hasRole(String role) throws NotLoggedInException {
        boolean result = true;
        if (this.getConfig().isEnabled()) {
            this.checkLoggedIn();
            result = this.getAuthorizer().hasRole(role);
        }
        return result;
    }

    @Override
    public boolean isLoggedIn() {
        boolean result = true;
        if (this.getConfig().isEnabled()) {
            result = this.getCurrentUser() != null;
        }
        return result;
    }

    @Override
    public void login() throws AuthenticationException {
        if (this.getConfig().isEnabled()) {
            this.getAuthenticator().authenticate();
            Beans.getBeanManager().fireEvent((Object)new AfterLoginSuccessful(){
                private static final long serialVersionUID = 1L;
            }, new Annotation[0]);
        }
    }

    @Override
    public void logout() throws NotLoggedInException {
        if (this.getConfig().isEnabled()) {
            this.checkLoggedIn();
            this.getAuthenticator().unAuthenticate();
            Beans.getBeanManager().fireEvent((Object)new AfterLogoutSuccessful(){
                private static final long serialVersionUID = 1L;
            }, new Annotation[0]);
        }
    }

    @Override
    public User getUser() {
        throw new DemoiselleException("Utilize o m\u00e9todo getCurrentUser() ao inv\u00e9s do getUser()");
    }

    @Override
    public Principal getCurrentUser() {
        Principal user = this.getAuthenticator().getUser();
        if (!this.getConfig().isEnabled() && user == null) {
            user = new EmptyUser();
        }
        return user;
    }

    private SecurityConfig getConfig() {
        return Beans.getReference(SecurityConfig.class);
    }

    @Override
    public void checkLoggedIn() throws NotLoggedInException {
        if (!this.isLoggedIn()) {
            ResourceBundle bundle = ResourceBundleProducer.create("demoiselle-core-bundle");
            throw new NotLoggedInException(bundle.getString("user-not-authenticated"));
        }
    }

    private static class EmptyUser
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EmptyUser() {
        }

        @Override
        public String getName() {
            return "demoiselle";
        }
    }
}

