/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.internal.management.ManagementNotificationEventImpl;
import br.gov.frameworkdemoiselle.internal.management.qualifier.AttributeChange;
import br.gov.frameworkdemoiselle.internal.management.qualifier.Generic;
import br.gov.frameworkdemoiselle.management.AttributeChangeNotification;
import br.gov.frameworkdemoiselle.management.GenericNotification;
import br.gov.frameworkdemoiselle.management.ManagementNotificationEvent;
import br.gov.frameworkdemoiselle.management.NotificationManager;
import br.gov.frameworkdemoiselle.util.Beans;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.event.Event;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;

public class NotificationManagerImpl
implements NotificationManager,
Serializable {
    @Inject
    @Generic
    private Event<ManagementNotificationEvent> genericNotificationEvent;
    @Inject
    @AttributeChange
    private Event<ManagementNotificationEvent> attributeChangeNotificationEvent;

    @Override
    public void sendNotification(GenericNotification notification) {
        if (!AttributeChangeNotification.class.isInstance(notification)) {
            this.getGenericNotificationEvent().fire((Object)new ManagementNotificationEventImpl(notification));
        } else {
            this.getAttributeChangeNotificationEvent().fire((Object)new ManagementNotificationEventImpl(notification));
        }
    }

    private Event<ManagementNotificationEvent> getGenericNotificationEvent() {
        if (this.genericNotificationEvent == null) {
            this.genericNotificationEvent = Beans.getReference(Event.class, new Annotation[]{new AnnotationLiteral<Generic>(){}});
        }
        return this.genericNotificationEvent;
    }

    private Event<ManagementNotificationEvent> getAttributeChangeNotificationEvent() {
        if (this.attributeChangeNotificationEvent == null) {
            this.attributeChangeNotificationEvent = Beans.getReference(Event.class, new Annotation[]{new AnnotationLiteral<AttributeChange>(){}});
        }
        return this.attributeChangeNotificationEvent;
    }
}

