/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.internal.implementation.StrategySelector;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.message.DefaultMessage;
import br.gov.frameworkdemoiselle.message.Message;
import br.gov.frameworkdemoiselle.message.MessageAppender;
import br.gov.frameworkdemoiselle.message.MessageContext;
import br.gov.frameworkdemoiselle.message.SeverityType;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class MessageContextImpl
implements Serializable,
MessageContext {
    private static final long serialVersionUID = 1L;
    @Deprecated
    private final transient List<Message> messages = new ArrayList<Message>();
    private static transient ResourceBundle bundle;
    private static transient Logger logger;

    @Override
    public void add(Message message, Object ... params) {
        Message aux = params != null ? new DefaultMessage(message.getText(), message.getSeverity(), params) : message;
        MessageContextImpl.getLogger().debug(MessageContextImpl.getBundle().getString("adding-message-to-context", message.toString()));
        this.getAppender().append(aux);
    }

    private MessageAppender getAppender() {
        Class<MessageAppender> appenderClass = StrategySelector.selectClass(MessageAppender.class);
        return Beans.getReference(appenderClass);
    }

    @Override
    public void add(String text, Object ... params) {
        this.add(text, null, params);
    }

    @Override
    public void add(String text, SeverityType severity, Object ... params) {
        this.add(new DefaultMessage(text, severity, params), new Object[0]);
    }

    @Override
    @Deprecated
    public List<Message> getMessages() {
        return this.messages;
    }

    @Override
    @Deprecated
    public void clear() {
        MessageContextImpl.getLogger().debug(MessageContextImpl.getBundle().getString("cleaning-message-context"));
        this.messages.clear();
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = ResourceBundleProducer.create("demoiselle-core-bundle");
        }
        return bundle;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerProducer.create(MessageContext.class);
        }
        return logger;
    }
}

