/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.configuration.ConfigurationValueExtractor;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.DataConfiguration;
import org.apache.commons.lang.ClassUtils;

@Priority(value=2147483547)
public class ConfigurationPrimitiveOrWrapperValueExtractor
implements ConfigurationValueExtractor {
    private static final Set<Object> wrappers = new HashSet<Object>();

    @Override
    public Object getValue(String prefix, String key, Field field, Configuration configuration) throws Exception {
        Object value = new DataConfiguration(configuration).get(ClassUtils.primitiveToWrapper(field.getType()), prefix + key);
        return value;
    }

    @Override
    public boolean isSupported(Field field) {
        return field.getType().isPrimitive() || wrappers.contains(field.getType());
    }

    static {
        wrappers.add(Boolean.class);
        wrappers.add(Byte.class);
        wrappers.add(Character.class);
        wrappers.add(Short.class);
        wrappers.add(Integer.class);
        wrappers.add(Long.class);
        wrappers.add(Double.class);
        wrappers.add(Float.class);
        wrappers.add(Void.TYPE);
    }
}

