/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.exception.ApplicationException;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.message.SeverityType;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.slf4j.Logger;

public class AnnotatedMethodProcessor<T>
implements Comparable<AnnotatedMethodProcessor<T>> {
    private AnnotatedMethod<T> annotatedMethod;
    private ResourceBundle bundle;

    public AnnotatedMethodProcessor(AnnotatedMethod<T> annotatedMethod) {
        this.annotatedMethod = annotatedMethod;
    }

    public AnnotatedMethod<T> getAnnotatedMethod() {
        return this.annotatedMethod;
    }

    protected T getReferencedBean() {
        Class<?> classType = this.getAnnotatedMethod().getJavaMember().getDeclaringClass();
        return (T)Beans.getReference(classType);
    }

    @Override
    public int compareTo(AnnotatedMethodProcessor<T> other) {
        Integer orderThis = AnnotatedMethodProcessor.getPriority(this.getAnnotatedMethod());
        Integer orderOther = AnnotatedMethodProcessor.getPriority(other.getAnnotatedMethod());
        return orderThis.compareTo(orderOther);
    }

    public boolean process(Object ... args) throws Exception {
        this.getLogger().info(this.getBundle().getString("processing", this.getAnnotatedMethod().getJavaMember().toGenericString()));
        try {
            this.getAnnotatedMethod().getJavaMember().invoke(this.getReferencedBean(), args);
        }
        catch (InvocationTargetException cause) {
            this.handleException(cause.getCause());
        }
        return true;
    }

    private void handleException(Throwable cause) throws Exception {
        ApplicationException ann = cause.getClass().getAnnotation(ApplicationException.class);
        if (ann == null || SeverityType.FATAL == ann.severity()) {
            throw cause instanceof Exception ? (Exception)cause : new Exception(cause);
        }
        switch (ann.severity()) {
            case INFO: {
                this.getLogger().info(cause.getMessage());
                break;
            }
            case WARN: {
                this.getLogger().warn(cause.getMessage());
                break;
            }
            default: {
                this.getLogger().error(this.getBundle().getString("processing-fail"), cause);
            }
        }
    }

    private static <T> Integer getPriority(AnnotatedMethod<T> annotatedMethod) {
        Integer priority = Integer.MAX_VALUE;
        Priority annotation = (Priority)annotatedMethod.getAnnotation(Priority.class);
        if (annotation != null) {
            priority = annotation.value();
        }
        return priority;
    }

    protected ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundleProducer.create("demoiselle-core-bundle", Locale.getDefault());
        }
        return this.bundle;
    }

    protected Logger getLogger() {
        return LoggerProducer.create(this.getClass());
    }
}

