/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.context.CustomContext;
import br.gov.frameworkdemoiselle.internal.context.CustomContextCounter;
import br.gov.frameworkdemoiselle.internal.context.StaticContext;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import org.slf4j.Logger;

public class ContextManager {
    private static List<CustomContextCounter> contexts = Collections.synchronizedList(new ArrayList());
    private static boolean initialized = false;
    private static ResourceBundle bundle;
    private static Logger logger;

    private ContextManager() {
    }

    public static void initialize(AfterBeanDiscovery event) {
        if (initialized) {
            return;
        }
        ContextManager.add(new StaticContext(), event);
        initialized = true;
    }

    public static void add(CustomContext context, AfterBeanDiscovery event) {
        for (CustomContextCounter contextCounter : contexts) {
            if (!contextCounter.isSame(context.getClass(), context.getScope())) continue;
            ContextManager.getLogger().trace(ContextManager.getBundle().getString("bootstrap-context-already-managed", context.getClass().getCanonicalName(), context.getScope().getCanonicalName()));
            return;
        }
        ContextManager.getLogger().trace(ContextManager.getBundle().getString("bootstrap-context-added", context.getClass().getCanonicalName(), context.getScope().getCanonicalName()));
        context.setActive(false);
        event.addContext((Context)context);
        contexts.add(new CustomContextCounter(context));
    }

    public static synchronized void activate(Class<? extends CustomContext> customContextClass, Class<? extends Annotation> scope) {
        if (!initialized) {
            throw new DemoiselleException(ContextManager.getBundle().getString("custom-context-manager-not-initialized"));
        }
        for (CustomContextCounter context : contexts) {
            if (!context.isSame(customContextClass, scope)) continue;
            context.activate();
            return;
        }
        throw new DemoiselleException(ContextManager.getBundle().getString("custom-context-not-found", customContextClass.getCanonicalName(), scope.getSimpleName()));
    }

    public static synchronized void deactivate(Class<? extends CustomContext> customContextClass, Class<? extends Annotation> scope) {
        if (!initialized) {
            throw new DemoiselleException(ContextManager.getBundle().getString("custom-context-manager-not-initialized"));
        }
        for (CustomContextCounter context : contexts) {
            if (!context.isSame(customContextClass, scope)) continue;
            context.deactivate();
            return;
        }
        throw new DemoiselleException(ContextManager.getBundle().getString("custom-context-not-found", customContextClass.getCanonicalName(), scope.getSimpleName()));
    }

    public static synchronized void shutdown() {
        for (CustomContextCounter context : contexts) {
            context.shutdown();
        }
        contexts.clear();
        initialized = false;
    }

    static Logger getLogger() {
        if (logger == null) {
            logger = LoggerProducer.create(ContextManager.class);
        }
        return logger;
    }

    static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = ResourceBundleProducer.create("demoiselle-core-bundle", Locale.getDefault());
        }
        return bundle;
    }
}

