/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.message;

import br.gov.frameworkdemoiselle.message.Message;
import br.gov.frameworkdemoiselle.message.SeverityType;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import br.gov.frameworkdemoiselle.util.Strings;
import javax.enterprise.inject.Alternative;

@Alternative
public class DefaultMessage
implements Message {
    private final String originalText;
    private String parsedText;
    private final SeverityType severity;
    private final Object[] params;
    private final ResourceBundle bundle;
    public static final SeverityType DEFAULT_SEVERITY = SeverityType.INFO;

    public DefaultMessage(String text, SeverityType severity, Object ... params) {
        this.originalText = text;
        this.severity = severity == null ? DEFAULT_SEVERITY : severity;
        this.params = params;
        this.bundle = Beans.getReference(ResourceBundle.class);
    }

    public DefaultMessage(String text, Object ... params) {
        this(text, null, params);
    }

    @Override
    public String getText() {
        this.initParsedText();
        return this.parsedText;
    }

    private void initParsedText() {
        if (this.parsedText == null) {
            if (Strings.isResourceBundleKeyFormat(this.originalText)) {
                this.parsedText = this.bundle.getString(Strings.removeBraces(this.originalText));
            } else if (this.originalText != null) {
                this.parsedText = new String(this.originalText);
            }
            this.parsedText = Strings.getString(this.parsedText, this.params);
        }
    }

    @Override
    public SeverityType getSeverity() {
        return this.severity;
    }

    public String toString() {
        this.initParsedText();
        return Strings.toString(this);
    }
}

