/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.configuration.ConfigurationException;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class StrategySelector
implements Serializable {
    public static final int CORE_PRIORITY = Integer.MAX_VALUE;
    public static final int EXTENSIONS_L1_PRIORITY = 2147483547;
    public static final int EXTENSIONS_L2_PRIORITY = 0x7FFFFF37;
    public static final int COMPONENTS_PRIORITY = 2147483347;
    private static final long serialVersionUID = 1L;
    private static ResourceBundle bundle;

    private StrategySelector() {
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = ResourceBundleProducer.create("demoiselle-core-bundle");
        }
        return bundle;
    }

    public static <T> Class<? extends T> getClass(Class<T> type, List<Class<? extends T>> options) throws ConfigurationException {
        Class<T> selected = null;
        for (Class<T> clazz : options) {
            if (selected != null && StrategySelector.getPriority(clazz) >= StrategySelector.getPriority(selected)) continue;
            selected = clazz;
        }
        StrategySelector.checkForAmbiguity(type, selected, options);
        return selected;
    }

    private static <T> void checkForAmbiguity(Class<T> type, Class<? extends T> selected, List<Class<? extends T>> options) throws ConfigurationException {
        int selectedPriority = StrategySelector.getPriority(selected);
        ArrayList<Class<T>> ambiguous = new ArrayList<Class<T>>();
        for (Class<T> clazz : options) {
            if (selected == clazz || selectedPriority != StrategySelector.getPriority(clazz)) continue;
            ambiguous.add(clazz);
        }
        if (!ambiguous.isEmpty()) {
            ambiguous.add(selected);
            String message = StrategySelector.getExceptionMessage(type, ambiguous);
            throw new ConfigurationException(message);
        }
    }

    private static <T> String getExceptionMessage(Class<T> type, List<Class<? extends T>> ambiguous) {
        StringBuffer classes = new StringBuffer();
        int i = 0;
        for (Class<T> clazz : ambiguous) {
            if (i++ != 0) {
                classes.append(", ");
            }
            classes.append(clazz.getCanonicalName());
        }
        return StrategySelector.getBundle().getString("ambiguous-strategy-resolution", type.getCanonicalName(), classes.toString());
    }

    private static <T> int getPriority(Class<T> type) {
        int result = Integer.MIN_VALUE;
        Priority priority = type.getAnnotation(Priority.class);
        if (priority != null) {
            result = priority.value();
        }
        return result;
    }
}

