/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import br.gov.frameworkdemoiselle.internal.context.CustomContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;

public abstract class AbstractCustomContext
implements CustomContext {
    private boolean active;
    private final Class<? extends Annotation> scope;

    public AbstractCustomContext(Class<? extends Annotation> scope, boolean active) {
        this.scope = scope;
        this.active = active;
    }

    protected abstract Store getStore();

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Object instance = null;
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        Class<?> type = this.getType(contextual);
        if (this.getStore().contains(type)) {
            instance = this.getStore().get(type);
        } else if (creationalContext != null) {
            instance = contextual.create(creationalContext);
            this.getStore().put(type, instance);
        }
        return (T)instance;
    }

    private <T> Class<?> getType(Contextual<T> contextual) {
        Bean bean = (Bean)contextual;
        return bean.getBeanClass();
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    protected static Store createStore() {
        return new Store();
    }

    static class Store {
        private Map<ClassLoader, Map<Class<?>, Object>> cache = Collections.synchronizedMap(new HashMap());

        private Store() {
        }

        private boolean contains(Class<?> type) {
            return this.getMap().containsKey(type);
        }

        private Object get(Class<?> type) {
            return this.getMap().get(type);
        }

        private void put(Class<?> type, Object instance) {
            this.getMap().put(type, instance);
        }

        private Map<Class<?>, Object> getMap() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (!this.cache.containsKey(classLoader)) {
                this.cache.put(classLoader, Collections.synchronizedMap(new HashMap()));
            }
            return this.cache.get(classLoader);
        }
    }
}

