/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.internal.context.Contexts;
import br.gov.frameworkdemoiselle.internal.context.CustomContext;
import br.gov.frameworkdemoiselle.internal.context.StaticContext;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.slf4j.Logger;

public class CoreBootstrap
implements Extension {
    private final Map<Class<?>, AnnotatedType<?>> beans = new HashMap();
    private Logger logger;
    private ResourceBundle bundle;
    private AfterBeanDiscovery afterBeanDiscoveryEvent;
    private List<CustomContext> customContexts = new ArrayList<CustomContext>();

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerProducer.create(CoreBootstrap.class);
        }
        return this.logger;
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundleProducer.create("demoiselle-core-bundle", Locale.getDefault());
        }
        return this.bundle;
    }

    public boolean isAnnotatedType(Class<?> type) {
        return this.beans.containsKey(type);
    }

    public void engineOn(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        Logger log = this.getLogger();
        String description = this.getBundle().getString("engine-on");
        log.info(description);
        Beans.setBeanManager(beanManager);
        description = this.getBundle().getString("setting-up-bean-manager", Beans.class.getCanonicalName());
        log.info(description);
    }

    protected <T> void detectAnnotation(@Observes ProcessAnnotatedType<T> event) {
        this.beans.put(event.getAnnotatedType().getJavaClass(), event.getAnnotatedType());
    }

    public void storeContexts(@Observes AfterBeanDiscovery event) {
        this.customContexts.add(new StaticContext());
        this.afterBeanDiscoveryEvent = event;
    }

    public void takeOff(@Observes AfterDeploymentValidation event) {
        for (CustomContext tempContext : this.customContexts) {
            Contexts.add(tempContext, this.afterBeanDiscoveryEvent);
        }
        this.getLogger().info(this.getBundle().getString("taking-off"));
    }

    public void engineOff(@Observes BeforeShutdown event) {
        for (CustomContext tempContext : this.customContexts) {
            Contexts.remove(tempContext);
        }
        this.getLogger().info(this.getBundle().getString("engine-off"));
    }
}

