/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.annotation.Ignore;
import br.gov.frameworkdemoiselle.util.Reflections;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Strings {
    private Strings() {
    }

    public static boolean isResourceBundleKeyFormat(String key) {
        return Pattern.matches("^\\{(.+)\\}$", key == null ? "" : key);
    }

    public static String removeChars(String string, char ... chars) {
        if (string != null) {
            for (char ch : chars) {
                string = string.replace(String.valueOf(ch), "");
            }
        }
        return string;
    }

    public static String insertZeros(String string, int howMuchZeros) {
        StringBuffer result = new StringBuffer((string == null ? "" : string).trim());
        int difference = howMuchZeros - result.toString().length();
        for (int j = 0; j < difference; ++j) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    public static String getString(String string, Object ... params) {
        String result = null;
        if (string != null) {
            result = new String(string);
        }
        if (params != null && string != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                result = result.replaceAll("\\{" + i + "\\}", Matcher.quoteReplacement(params[i].toString()));
            }
        }
        return result;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static String toString(Object object) {
        StringBuffer result = new StringBuffer();
        if (object != null) {
            result.append(object.getClass().getSimpleName());
            result.append(" [");
            boolean first = true;
            for (Field field : Reflections.getNonStaticDeclaredFields(object.getClass())) {
                if (field.isAnnotationPresent(Ignore.class)) continue;
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(field.getName());
                result.append("=");
                Object fieldValue = Reflections.getFieldValue(field, object);
                result.append(fieldValue != null && fieldValue.getClass().isArray() ? Arrays.toString((Object[])fieldValue) : fieldValue);
            }
            result.append("]");
        }
        return result.toString();
    }

    public static String camelCaseToSymbolSeparated(String string, String symbol) {
        if (symbol == null) {
            symbol = "";
        }
        return string == null ? null : string.replaceAll("\\B([A-Z])", symbol + "$1").toLowerCase();
    }

    public static String firstToUpper(String string) {
        String result = string;
        if (!Strings.isEmpty(string)) {
            result = string.toUpperCase().charAt(0) + (string.length() > 1 ? string.substring(1) : "");
        }
        return result;
    }

    public static String removeBraces(String string) {
        String result = string;
        if (Strings.isResourceBundleKeyFormat(string)) {
            result = string.substring(1, string.length() - 1);
        }
        return result;
    }

    public static String insertBraces(String string) {
        String result = string;
        if (!Strings.isEmpty(string)) {
            result = "{" + string + "}";
        }
        return result;
    }
}

