/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.internal.bootstrap.TransactionBootstrap;
import br.gov.frameworkdemoiselle.internal.configuration.TransactionConfig;
import br.gov.frameworkdemoiselle.internal.implementation.StrategySelector;
import br.gov.frameworkdemoiselle.transaction.Transaction;
import br.gov.frameworkdemoiselle.transaction.TransactionContext;
import br.gov.frameworkdemoiselle.util.Beans;
import javax.inject.Named;

@Named(value="transactionContext")
public class TransactionContextImpl
implements TransactionContext {
    private static final long serialVersionUID = 1L;
    private Transaction transaction;

    private Transaction getTransaction() {
        if (this.transaction == null) {
            TransactionBootstrap bootstrap = Beans.getReference(TransactionBootstrap.class);
            Class<? extends Transaction> clazz = this.getConfig().getTransactionClass();
            if (clazz == null) {
                clazz = StrategySelector.getClass(Transaction.class, bootstrap.getCache());
            }
            this.transaction = Beans.getReference(clazz);
        }
        return this.transaction;
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.getTransaction();
    }

    private TransactionConfig getConfig() {
        return Beans.getReference(TransactionConfig.class);
    }
}

