/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public final class Beans {
    private static BeanManager manager;

    private Beans() {
    }

    public static void setBeanManager(BeanManager beanManager) {
        manager = beanManager;
    }

    public static BeanManager getBeanManager() {
        return manager;
    }

    public static <T> T getReference(Class<T> beanClass, Annotation ... qualifiers) {
        T instance;
        try {
            instance = Beans.getReference(manager.getBeans(beanClass, qualifiers));
        }
        catch (NoSuchElementException cause) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(beanClass.getCanonicalName());
            for (Annotation qualifier : qualifiers) {
                buffer.append(", ");
                buffer.append(qualifier.getClass().getCanonicalName());
            }
            String message = Beans.getBundle().getString("bean-not-found", buffer.toString());
            throw new DemoiselleException(message, cause);
        }
        return instance;
    }

    public static <T> T getReference(Class<T> beanClass) {
        T instance;
        try {
            instance = Beans.getReference(manager.getBeans(beanClass, new Annotation[0]));
        }
        catch (NoSuchElementException cause) {
            String message = Beans.getBundle().getString("bean-not-found", beanClass.getCanonicalName());
            throw new DemoiselleException(message, cause);
        }
        return instance;
    }

    public static <T> T getReference(String beanName) {
        T instance;
        try {
            instance = Beans.getReference(manager.getBeans(beanName));
        }
        catch (NoSuchElementException cause) {
            String message = Beans.getBundle().getString("bean-not-found", beanName);
            throw new DemoiselleException(message, cause);
        }
        return instance;
    }

    private static <T> T getReference(Set<Bean<?>> beans) {
        Bean<?> bean = beans.iterator().next();
        return (T)manager.getReference(bean, (Type)bean.getBeanClass(), manager.createCreationalContext(bean));
    }

    private static ResourceBundle getBundle() {
        return ResourceBundleProducer.create("demoiselle-core-bundle", Locale.getDefault());
    }
}

