/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.interceptor;

import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.security.AuthorizationException;
import br.gov.frameworkdemoiselle.security.RequiredRole;
import br.gov.frameworkdemoiselle.security.SecurityContext;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

@Interceptor
@RequiredRole(value={""})
public class RequiredRoleInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SecurityContext securityContext;
    private static ResourceBundle bundle;
    private static Logger logger;

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        List<String> roles = this.getRoles(ic);
        if (this.getSecurityContext().isLoggedIn()) {
            RequiredRoleInterceptor.getLogger().info(RequiredRoleInterceptor.getBundle().getString("has-role-verification", this.getSecurityContext().getUser().getId(), roles));
        }
        ArrayList<String> userRoles = new ArrayList<String>();
        for (String role : roles) {
            if (!this.getSecurityContext().hasRole(role)) continue;
            userRoles.add(role);
        }
        if (userRoles.isEmpty()) {
            RequiredRoleInterceptor.getLogger().error(RequiredRoleInterceptor.getBundle().getString("does-not-have-role", this.getSecurityContext().getUser().getId(), roles));
            AuthorizationException a = new AuthorizationException(null);
            throw new AuthorizationException(RequiredRoleInterceptor.getBundle().getString("does-not-have-role-ui", roles));
        }
        RequiredRoleInterceptor.getLogger().debug(RequiredRoleInterceptor.getBundle().getString("user-has-role", this.getSecurityContext().getUser().getId(), userRoles));
        return ic.proceed();
    }

    private List<String> getRoles(InvocationContext ic) {
        String[] roles = new String[]{};
        if (ic.getMethod().getAnnotation(RequiredRole.class) == null) {
            if (ic.getTarget().getClass().getAnnotation(RequiredRole.class) != null) {
                roles = ic.getTarget().getClass().getAnnotation(RequiredRole.class).value();
            }
        } else {
            roles = ic.getMethod().getAnnotation(RequiredRole.class).value();
        }
        return Arrays.asList(roles);
    }

    private SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = Beans.getReference(SecurityContext.class);
        }
        return this.securityContext;
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = ResourceBundleProducer.create("demoiselle-core-bundle");
        }
        return bundle;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerProducer.create(RequiredRoleInterceptor.class);
        }
        return logger;
    }
}

