/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.internal.bootstrap.AuthenticatorBootstrap;
import br.gov.frameworkdemoiselle.internal.bootstrap.AuthorizerBootstrap;
import br.gov.frameworkdemoiselle.internal.configuration.SecurityConfig;
import br.gov.frameworkdemoiselle.internal.configuration.SecurityConfigImpl;
import br.gov.frameworkdemoiselle.internal.implementation.StrategySelector;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.security.AfterLoginSuccessful;
import br.gov.frameworkdemoiselle.security.AfterLogoutSuccessful;
import br.gov.frameworkdemoiselle.security.Authenticator;
import br.gov.frameworkdemoiselle.security.Authorizer;
import br.gov.frameworkdemoiselle.security.NotLoggedInException;
import br.gov.frameworkdemoiselle.security.SecurityContext;
import br.gov.frameworkdemoiselle.security.User;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import javax.inject.Named;

@Named(value="securityContext")
public class SecurityContextImpl
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private Authenticator authenticator;
    private Authorizer authorizer;

    private Authenticator getAuthenticator() {
        if (this.authenticator == null) {
            AuthenticatorBootstrap bootstrap = Beans.getReference(AuthenticatorBootstrap.class);
            Class<? extends Authenticator> clazz = this.getConfig().getAuthenticatorClass();
            if (clazz == null) {
                clazz = StrategySelector.getClass(Authenticator.class, bootstrap.getCache());
            }
            this.authenticator = Beans.getReference(clazz);
        }
        return this.authenticator;
    }

    private Authorizer getAuthorizer() {
        if (this.authorizer == null) {
            AuthorizerBootstrap bootstrap = Beans.getReference(AuthorizerBootstrap.class);
            Class<? extends Authorizer> clazz = this.getConfig().getAuthorizerClass();
            if (clazz == null) {
                clazz = StrategySelector.getClass(Authorizer.class, bootstrap.getCache());
            }
            this.authorizer = Beans.getReference(clazz);
        }
        return this.authorizer;
    }

    @Override
    public boolean hasPermission(String resource, String operation) throws NotLoggedInException {
        if (this.getConfig().isEnabled()) {
            this.checkLoggedIn();
            return this.getAuthorizer().hasPermission(resource, operation);
        }
        return true;
    }

    @Override
    public boolean hasRole(String role) throws NotLoggedInException {
        if (this.getConfig().isEnabled()) {
            this.checkLoggedIn();
            return this.getAuthorizer().hasRole(role);
        }
        return true;
    }

    @Override
    public boolean isLoggedIn() {
        if (this.getConfig().isEnabled()) {
            return this.getUser() != null;
        }
        return true;
    }

    @Override
    public void login() {
        if (this.getConfig().isEnabled() && this.getAuthenticator().authenticate()) {
            Beans.getBeanManager().fireEvent((Object)new AfterLoginSuccessful(){
                private static final long serialVersionUID = 1L;
            }, new Annotation[0]);
        }
    }

    @Override
    public void logout() throws NotLoggedInException {
        if (this.getConfig().isEnabled()) {
            this.checkLoggedIn();
            this.getAuthenticator().unAuthenticate();
            Beans.getBeanManager().fireEvent((Object)new AfterLogoutSuccessful(){
                private static final long serialVersionUID = 1L;
            }, new Annotation[0]);
        }
    }

    @Override
    public User getUser() {
        User user = this.getAuthenticator().getUser();
        if (!this.getConfig().isEnabled() && user == null) {
            user = new User(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setAttribute(Object key, Object value) {
                }

                @Override
                public String getId() {
                    return "demoiselle";
                }

                @Override
                public Object getAttribute(Object key) {
                    return null;
                }
            };
        }
        return user;
    }

    private SecurityConfig getConfig() {
        return Beans.getReference(SecurityConfigImpl.class);
    }

    private void checkLoggedIn() throws NotLoggedInException {
        if (!this.isLoggedIn()) {
            ResourceBundle bundle = ResourceBundleProducer.create("demoiselle-core-bundle");
            throw new NotLoggedInException(bundle.getString("user-not-authenticated"));
        }
    }
}

