/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.configuration;

import br.gov.frameworkdemoiselle.annotation.Ignore;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.configuration.ConfigType;
import br.gov.frameworkdemoiselle.configuration.ConfigurationException;
import br.gov.frameworkdemoiselle.internal.bootstrap.CoreBootstrap;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Reflections;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import br.gov.frameworkdemoiselle.util.Strings;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.DataConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.slf4j.Logger;

public class ConfigurationLoader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle bundle;
    private static Logger logger;

    public void load(Object object) throws ConfigurationException {
        Class<?> config = object.getClass();
        CoreBootstrap bootstrap = Beans.getReference(CoreBootstrap.class);
        if (!bootstrap.isAnnotatedType(config)) {
            config = config.getSuperclass();
            ConfigurationLoader.getLogger().debug(ConfigurationLoader.getBundle().getString("proxy-detected", config, config.getClass().getSuperclass()));
        }
        ConfigurationLoader.getLogger().debug(ConfigurationLoader.getBundle().getString("loading-configuration-class", config.getName()));
        for (Field field : Reflections.getNonStaticDeclaredFields(config)) {
            this.loadField(field, object, config);
        }
    }

    private void loadField(Field field, Object object, Class<?> clazz) {
        ConfigType type;
        String resource;
        Configuration config;
        if (!field.isAnnotationPresent(Ignore.class) && clazz.isAnnotationPresent(br.gov.frameworkdemoiselle.configuration.Configuration.class) && (config = this.getConfiguration(resource = clazz.getAnnotation(br.gov.frameworkdemoiselle.configuration.Configuration.class).resource(), type = clazz.getAnnotation(br.gov.frameworkdemoiselle.configuration.Configuration.class).type())) != null) {
            String key = this.getKey(field, clazz, config);
            Object value = this.getValue(key, field, config);
            this.validate(field, key, value, resource);
            this.setValue(field, key, object, value);
        }
    }

    private void setValue(Field field, String key, Object object, Object value) {
        if (value != null) {
            Reflections.setFieldValue(field, object, value);
            ConfigurationLoader.getLogger().debug(ConfigurationLoader.getBundle().getString("configuration-field-loaded", key, field.getName(), value));
        }
    }

    private void validate(Field field, String key, Object value, String resource) {
        if (field.isAnnotationPresent(NotNull.class) && value == null) {
            throw new ConfigurationException(ConfigurationLoader.getBundle().getString("configuration-attribute-is-mandatory", key, resource));
        }
    }

    private String getKey(Field field, Class<?> clazz, Configuration config) {
        String prefix = this.getPrefix(field, clazz);
        StringBuffer key = new StringBuffer();
        key.append(prefix);
        if (field.isAnnotationPresent(Name.class)) {
            key.append(this.getKeyByAnnotation(field));
        } else {
            key.append(this.getKeyByConvention(field, prefix, config));
        }
        return key.toString();
    }

    private String getPrefix(Field field, Class<?> type) {
        String prefix = "";
        br.gov.frameworkdemoiselle.configuration.Configuration classAnnotation = type.getAnnotation(br.gov.frameworkdemoiselle.configuration.Configuration.class);
        if (!Strings.isEmpty(classAnnotation.prefix())) {
            prefix = classAnnotation.prefix() + ".";
        }
        return prefix;
    }

    private String getKeyByAnnotation(Field field) {
        String key = null;
        Name nameAnnotation = field.getAnnotation(Name.class);
        if (Strings.isEmpty(nameAnnotation.value())) {
            throw new ConfigurationException(ConfigurationLoader.getBundle().getString("configuration-name-attribute-cant-be-empty"));
        }
        key = nameAnnotation.value();
        return key;
    }

    private String getKeyByConvention(Field field, String prefix, Configuration config) {
        HashSet<String> conventions = new HashSet<String>();
        conventions.add(field.getName());
        conventions.add(Strings.camelCaseToSymbolSeparated(field.getName(), "."));
        conventions.add(Strings.camelCaseToSymbolSeparated(field.getName(), "_"));
        conventions.add(field.getName().toLowerCase());
        conventions.add(field.getName().toUpperCase());
        int matches = 0;
        String key = field.getName();
        for (String convention : conventions) {
            if (!config.containsKey(prefix + convention)) continue;
            key = convention;
            ++matches;
        }
        if (matches == 0) {
            ConfigurationLoader.getLogger().debug(ConfigurationLoader.getBundle().getString("configuration-key-not-found", key, conventions));
        } else if (matches > 1) {
            throw new ConfigurationException(ConfigurationLoader.getBundle().getString("ambiguous-key", field.getName(), field.getDeclaringClass()));
        }
        return key;
    }

    private Configuration getConfiguration(String resource, ConfigType type) {
        SystemConfiguration result = null;
        try {
            switch (type) {
                case SYSTEM: {
                    result = new SystemConfiguration();
                    break;
                }
                case PROPERTIES: {
                    URL url = ConfigurationLoader.getResourceAsURL(resource + ".properties");
                    if (url != null) {
                        result = new DataConfiguration((Configuration)new PropertiesConfiguration(url));
                    }
                    break;
                }
                case XML: {
                    URL url = ConfigurationLoader.getResourceAsURL(resource + ".xml");
                    if (url != null) {
                        result = new DataConfiguration((Configuration)new XMLConfiguration(url));
                    }
                    break;
                }
                default: {
                    throw new ConfigurationException(ConfigurationLoader.getBundle().getString("configuration-type-not-implemented-yet", type.name()));
                }
            }
        }
        catch (Exception cause) {
            throw new ConfigurationException(ConfigurationLoader.getBundle().getString("error-creating-configuration-from-resource", resource), cause);
        }
        return result;
    }

    private <T> T getValue(String key, Field field, Configuration config) {
        Class<?> fieldClass = field.getType();
        Object value = fieldClass.isArray() ? this.getArray(key, field, config) : (fieldClass.equals(Properties.class) ? this.getProperty(key, config) : (fieldClass.equals(Class.class) ? this.getClass(key, field, config) : this.getBasic(key, field, config)));
        return (T)value;
    }

    private <T> Object getArray(String key, Field field, Configuration config) {
        Object value = null;
        Class<?> fieldClass = field.getType();
        try {
            String methodName = "get";
            methodName = methodName + Strings.firstToUpper(fieldClass.getSimpleName());
            methodName = Strings.removeChars(methodName, '[', ']');
            methodName = methodName + "Array";
            Method method = config.getClass().getMethod(methodName, String.class);
            value = method.invoke((Object)config, key);
        }
        catch (Throwable cause) {
            throw new ConfigurationException(ConfigurationLoader.getBundle().getString("error-converting-to-type", fieldClass.getName()), cause);
        }
        return value;
    }

    private <T> Object getBasic(String key, Field field, Configuration config) {
        Object value = null;
        Class<?> fieldClass = field.getType();
        try {
            String methodName = "get";
            methodName = methodName + this.discoveryGenericType(field);
            methodName = methodName + Strings.firstToUpper(fieldClass.getSimpleName());
            if (!fieldClass.isPrimitive()) {
                Method method = config.getClass().getMethod(methodName, String.class, fieldClass);
                value = method.invoke((Object)config, key, null);
            } else if (config.containsKey(key)) {
                Method method = config.getClass().getMethod(methodName, String.class);
                value = method.invoke((Object)config, key);
            }
        }
        catch (Throwable cause) {
            throw new ConfigurationException(ConfigurationLoader.getBundle().getString("error-converting-to-type", fieldClass.getName()), cause);
        }
        return value;
    }

    private <T> Object getClass(String key, Field field, Configuration config) {
        Class<?> value = null;
        try {
            String canonicalName = config.getString(key);
            if (canonicalName != null) {
                ClassLoader classLoader = ConfigurationLoader.getClassLoaderForClass(canonicalName);
                value = Class.forName(canonicalName, true, classLoader);
            }
        }
        catch (Exception cause) {
            throw new ConfigurationException(null, cause);
        }
        return value;
    }

    private String discoveryGenericType(Field field) {
        ParameterizedType type;
        Type[] fieldArgumentTypes;
        Type[] arr$;
        int len$;
        int i$;
        Type genericFieldType = field.getGenericType();
        if (genericFieldType instanceof ParameterizedType && (i$ = 0) < (len$ = (arr$ = (fieldArgumentTypes = (type = (ParameterizedType)genericFieldType).getActualTypeArguments())).length)) {
            Type fieldArgumentType = arr$[i$];
            Class fieldArgumentClass = (Class)fieldArgumentType;
            if ("String".equals(fieldArgumentClass.getSimpleName())) {
                return "";
            }
            return fieldArgumentClass.getSimpleName();
        }
        return "";
    }

    private Object getProperty(String key, Configuration config) {
        Properties value = null;
        Iterator iterator = config.getKeys(key);
        if (iterator.hasNext()) {
            Properties props = new Properties();
            while (iterator.hasNext()) {
                String fullKey = (String)iterator.next();
                String prefix = key + ".";
                String unprefixedKey = fullKey.substring(prefix.length());
                props.put(unprefixedKey, config.getString(fullKey));
            }
            value = props;
        }
        return value;
    }

    public static ClassLoader getClassLoaderForClass(String canonicalName) throws FileNotFoundException {
        return ConfigurationLoader.getClassLoaderForResource(canonicalName.replaceAll("\\.", "/") + ".class");
    }

    public static ClassLoader getClassLoaderForResource(String resource) throws FileNotFoundException {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        URL url = null;
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        if (result != null) {
            url = result.getResource(stripped);
        }
        if (url == null) {
            result = ConfigurationLoader.class.getClassLoader();
            url = ConfigurationLoader.class.getClassLoader().getResource(stripped);
        }
        if (url == null) {
            result = null;
        }
        return result;
    }

    public static URL getResourceAsURL(String resource) throws FileNotFoundException {
        ClassLoader classLoader = ConfigurationLoader.getClassLoaderForResource(resource);
        return classLoader != null ? classLoader.getResource(resource) : null;
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = ResourceBundleProducer.create("demoiselle-core-bundle");
        }
        return bundle;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerProducer.create(ConfigurationLoader.class);
        }
        return logger;
    }
}

