/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.slf4j.Logger;

public class CoreBootstrap
implements Extension {
    private final Map<Class<?>, AnnotatedType<?>> beans = new HashMap();
    private Logger logger;
    private ResourceBundle bundle;

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerProducer.create(CoreBootstrap.class);
        }
        return this.logger;
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundleProducer.create("demoiselle-core-bundle", Locale.getDefault());
        }
        return this.bundle;
    }

    public boolean isAnnotatedType(Class<?> type) {
        return this.beans.containsKey(type);
    }

    public void engineOn(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        Logger log = this.getLogger();
        String description = this.getBundle().getString("engine-on");
        log.info(description);
        Beans.setBeanManager(beanManager);
        description = this.getBundle().getString("setting-up-bean-manager", Beans.class.getCanonicalName());
        log.info(description);
    }

    protected <T> void detectAnnotation(@Observes ProcessAnnotatedType<T> event) {
        this.beans.put(event.getAnnotatedType().getJavaClass(), event.getAnnotatedType());
    }

    public void takeOff(@Observes AfterDeploymentValidation event) {
        String description = this.getBundle().getString("taking-off");
        Logger log = this.getLogger();
        log.info(description);
    }

    public void engineOff(@Observes BeforeShutdown event) {
        String description = this.getBundle().getString("engine-off");
        Logger log = this.getLogger();
        log.info(description);
    }
}

