/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.ViewScoped;
import br.gov.frameworkdemoiselle.internal.configuration.ConfigurationLoader;
import br.gov.frameworkdemoiselle.internal.context.Contexts;
import br.gov.frameworkdemoiselle.internal.context.CustomContext;
import br.gov.frameworkdemoiselle.internal.context.ThreadLocalContext;
import br.gov.frameworkdemoiselle.internal.implementation.AnnotatedMethodProcessor;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.util.Reflections;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.slf4j.Logger;

public abstract class AbstractLifecycleBootstrap<A extends Annotation>
implements Extension {
    private Class<A> annotationClass;
    private List<AnnotatedMethodProcessor> processors = Collections.synchronizedList(new ArrayList());
    private List<CustomContext> tempContexts = new ArrayList<CustomContext>();
    private AfterBeanDiscovery afterBeanDiscoveryEvent;
    private boolean registered = false;
    private ResourceBundle bundle;

    protected abstract Logger getLogger();

    protected ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundleProducer.create("demoiselle-core-bundle", Locale.getDefault());
        }
        return this.bundle;
    }

    protected <T> AnnotatedMethodProcessor<T> newProcessorInstance(AnnotatedMethod<T> annotatedMethod) {
        return new AnnotatedMethodProcessor<T>(annotatedMethod);
    }

    protected Class<A> getAnnotationClass() {
        if (this.annotationClass == null) {
            this.annotationClass = Reflections.getGenericTypeArgument(this.getClass(), 0);
        }
        return this.annotationClass;
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        for (AnnotatedMethod am : annotatedType.getMethods()) {
            if (!am.isAnnotationPresent(this.getAnnotationClass())) continue;
            AnnotatedMethod annotatedMethod = am;
            this.processors.add(this.newProcessorInstance(annotatedMethod));
        }
    }

    public void loadTempContexts(@Observes AfterBeanDiscovery event) {
        this.tempContexts.add(new ThreadLocalContext(ViewScoped.class));
        this.tempContexts.add(new ThreadLocalContext(SessionScoped.class));
        this.tempContexts.add(new ThreadLocalContext(ConversationScoped.class));
        this.tempContexts.add(new ThreadLocalContext(RequestScoped.class));
        this.afterBeanDiscoveryEvent = event;
    }

    protected synchronized void proccessEvent() {
        this.getLogger().debug(this.getBundle().getString("executing-all", this.annotationClass.getSimpleName()));
        Collections.sort(this.processors);
        Throwable failure = null;
        if (!this.registered) {
            for (CustomContext tempContext : this.tempContexts) {
                Contexts.add(tempContext, this.afterBeanDiscoveryEvent);
            }
            this.registered = true;
        }
        Iterator<AnnotatedMethodProcessor> iter = this.processors.iterator();
        while (iter.hasNext()) {
            AnnotatedMethodProcessor processor = iter.next();
            try {
                ClassLoader classLoader = ConfigurationLoader.getClassLoaderForClass(processor.getAnnotatedMethod().getDeclaringType().getJavaClass().getCanonicalName());
                if (!Thread.currentThread().getContextClassLoader().equals(classLoader)) continue;
                processor.process(new Object[0]);
                iter.remove();
            }
            catch (Throwable cause) {
                failure = cause;
            }
        }
        if (this.processors.isEmpty()) {
            this.unloadTempContexts();
        }
        if (failure != null) {
            throw new DemoiselleException(failure);
        }
    }

    private void unloadTempContexts() {
        for (CustomContext tempContext : this.tempContexts) {
            Contexts.remove(tempContext);
        }
    }
}

