/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.certificate.criptography;

public enum DigestAlgorithmEnum {
    SHA_1("SHA-1"),
    SHA_256("SHA-256"),
    SHA_512("SHA-512"),
    MD5("MD5");

    public static DigestAlgorithmEnum DEFAULT;
    private final String algorithm;

    private DigestAlgorithmEnum(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static DigestAlgorithmEnum getDigestAlgorithmEnum(String algorithm) {
        for (DigestAlgorithmEnum value : DigestAlgorithmEnum.values()) {
            if (!value.getAlgorithm().equalsIgnoreCase(algorithm)) continue;
            return value;
        }
        return null;
    }

    static {
        DEFAULT = SHA_1;
    }
}

