/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.certificate.criptography.factory;

import br.gov.frameworkdemoiselle.certificate.criptography.configuration.Configuration;

public abstract class GenericFactory<F> {
    private String className = null;

    public F factory() {
        F result = null;
        if (this.className == null) {
            this.className = Configuration.getInstance().getContentFromVariables(this.getVariableName());
        }
        result = this.className != null && this.className.length() > 0 ? (F)this.factoryFromClassName(this.className) : (F)this.factoryDefault();
        return result;
    }

    protected F factoryFromClassName(String className) {
        F result = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Throwable error) {
            throw new RuntimeException("Class [" + className + "] does not exist", error);
        }
        if (clazz != null) {
            try {
                result = (F)clazz.newInstance();
            }
            catch (Throwable error) {
                throw new RuntimeException("incompatible Class [" + clazz.getCanonicalName() + "]", error);
            }
        }
        return result;
    }

    public abstract F factoryDefault();

    protected abstract String getVariableName();
}

