/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.certificate.criptography.implementation;

import br.gov.frameworkdemoiselle.certificate.criptography.CriptographyException;
import br.gov.frameworkdemoiselle.certificate.criptography.Digest;
import br.gov.frameworkdemoiselle.certificate.criptography.DigestAlgorithmEnum;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestImpl
implements Digest {
    private String algorithm = DigestAlgorithmEnum.DEFAULT.getAlgorithm();
    private final int BUFSIZE = 128;

    @Override
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public byte[] digest(byte[] content) {
        byte[] result = null;
        if (this.algorithm == null) {
            this.algorithm = DigestAlgorithmEnum.DEFAULT.getAlgorithm();
        }
        if (content == null) {
            throw new CriptographyException("The content can not be null");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(this.algorithm);
            digest.update(content);
            result = digest.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CriptographyException("Error on digest content", ex);
        }
        return result;
    }

    @Override
    public byte[] digestFile(File file) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.algorithm);
            FileInputStream fileIS = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fileIS);
            DataInputStream dis = new DataInputStream(bis);
            DigestInputStream digin = new DigestInputStream(dis, md);
            byte[] buffer = new byte[128];
            while (digin.read(buffer, 0, 128) != -1) {
            }
            digin.close();
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CriptographyException("Failed to set algorithm", e);
        }
        catch (FileNotFoundException e) {
            throw new CriptographyException("File [" + file + "] not found", e);
        }
        catch (IOException e) {
            throw new CriptographyException("Error reading file [" + file + "]", e);
        }
    }

    @Override
    public String digestFileHex(File file) {
        byte[] bytes = this.digestFile(file);
        String hex = this.convertToHex(bytes);
        return hex;
    }

    @Override
    public String digestHex(byte[] content) {
        byte[] bytes = this.digest(content);
        String hex = this.convertToHex(bytes);
        return hex;
    }

    private String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    @Override
    public void setAlgorithm(DigestAlgorithmEnum algorithm) {
        this.setAlgorithm(algorithm.getAlgorithm());
    }
}

