/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.certificate.criptography.implementation;

import br.gov.frameworkdemoiselle.certificate.criptography.AsymmetricAlgorithmEnum;
import br.gov.frameworkdemoiselle.certificate.criptography.Criptography;
import br.gov.frameworkdemoiselle.certificate.criptography.CriptographyException;
import br.gov.frameworkdemoiselle.certificate.criptography.SymmetricAlgorithmEnum;
import com.sun.crypto.provider.SunJCE;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;

public class CriptographyImpl
implements Criptography {
    private String algorithm;
    private String keyAlgorithm;
    private Integer size;
    private Provider provider = new SunJCE();
    private Key key;
    private Cipher cipher;

    public CriptographyImpl() {
        this.setAlgorithm(SymmetricAlgorithmEnum.DEFAULT);
    }

    @Override
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void setAlgorithm(SymmetricAlgorithmEnum algorithm) {
        this.algorithm = algorithm.getAlgorithm();
        this.keyAlgorithm = algorithm.getKeyAlgorithm();
        this.size = algorithm.getSize();
    }

    @Override
    public void setAlgorithm(AsymmetricAlgorithmEnum algorithm) {
        this.algorithm = algorithm.getAlgorithm();
    }

    @Override
    public void setProvider(Provider provider) {
        this.provider = provider;
        if (provider != null) {
            Security.addProvider(this.provider);
        }
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    @Override
    public void setKey(Key key) {
        this.key = key;
    }

    @Override
    public Key generateKey() {
        try {
            KeyGenerator genKey = this.provider == null ? KeyGenerator.getInstance(this.keyAlgorithm) : KeyGenerator.getInstance(this.keyAlgorithm, this.provider);
            if (this.size != null) {
                genKey.init(this.size);
            }
            return genKey.generateKey();
        }
        catch (Exception e) {
            throw new CriptographyException("Error: Could not generate key", e);
        }
    }

    @Override
    public byte[] cipher(byte[] content) {
        try {
            return this.crypt(content, 1);
        }
        catch (Throwable e) {
            throw new CriptographyException("Encrypt Error", e);
        }
    }

    @Override
    public byte[] decipher(byte[] content) {
        try {
            return this.crypt(content, 2);
        }
        catch (Throwable e) {
            throw new CriptographyException("Decrypt Error", e);
        }
    }

    private byte[] crypt(byte[] content, int crypt_mode) {
        try {
            this.cipher = this.provider == null ? Cipher.getInstance(this.algorithm) : Cipher.getInstance(this.algorithm, this.provider);
            if (this.key == null) {
                throw new CriptographyException("Key is null");
            }
            this.cipher.init(crypt_mode, this.key);
            return this.cipher.doFinal(content);
        }
        catch (Throwable e) {
            throw new CriptographyException("Crypt Error", e);
        }
    }
}

