/*
 * Decompiled with CFR 0.152.
 */
package br.gov.cgu.utils;

import br.gov.cgu.utils.Tipo;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TipoSelectBuilder {
    public static final String OPCAO_PADRAO_TODOS = "Todos";
    public static final String OPCAO_PADRAO_SELECIONE = "(Selecione)";

    private TipoSelectBuilder() {
    }

    public static Map<String, String> build(List<? extends Tipo> entidades, String nomeOpcaoPadrao) {
        LinkedHashMap<String, String> selectList = new LinkedHashMap<String, String>();
        if (nomeOpcaoPadrao != null) {
            selectList.put("", nomeOpcaoPadrao);
        }
        if (entidades != null && entidades.size() > 0) {
            TipoSelectBuilder.gerarLista(entidades, selectList);
        }
        return selectList;
    }

    public static Map<String, String> build(List<? extends Tipo> entidades) {
        LinkedHashMap<String, String> selectList = new LinkedHashMap<String, String>();
        TipoSelectBuilder.gerarLista(entidades, selectList);
        return selectList;
    }

    private static void gerarLista(List<? extends Tipo> entidades, Map<String, String> selectList) {
        for (Tipo tipo : entidades) {
            if (tipo instanceof Enum) {
                selectList.put(((Enum)((Object)tipo)).name(), tipo.getDescricao());
                continue;
            }
            selectList.put(tipo.getId().toString(), tipo.getDescricao());
        }
    }

    public static <E extends Enum<E>> Map<String, String> gerarSelectComOpcaoPadraoTodos(Class<E> classeEnum) {
        return TipoSelectBuilder.buildDeEnum(classeEnum, OPCAO_PADRAO_TODOS);
    }

    public static <E extends Enum<E>> Map<String, String> gerarSelectComOpcaoPadraoSelecione(Class<E> classeEnum) {
        return TipoSelectBuilder.buildDeEnum(classeEnum, OPCAO_PADRAO_SELECIONE);
    }

    public static <E extends Enum<E>> Map<String, String> buildDeEnum(Class<E> classeEnum, String nomeOpcaoPadrao) {
        return TipoSelectBuilder.build(Arrays.asList(classeEnum.getEnumConstants()), nomeOpcaoPadrao);
    }
}

