/*
 * Decompiled with CFR 0.152.
 */
package br.gov.cgu.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PasswordUtils {
    private static Logger logger = LoggerFactory.getLogger(PasswordUtils.class);
    private static final int TAMANHO_PADRAO_SENHA_RANDOMICA = 8;
    private static final int ITERATIONS = 1024;
    private static final int SALT_LEN = 32;
    private static final int DESIRED_KEY_LEN = 256;

    private PasswordUtils() {
    }

    public static String getSaltedHash(String password) {
        try {
            byte[] salt = SecureRandom.getInstance("SHA1PRNG").generateSeed(32);
            return Base64.encodeBase64String((byte[])salt) + "$" + PasswordUtils.hash(password, salt);
        }
        catch (Exception e) {
            logger.error("Erro no GetInstance(SHA1PRNG)", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean check(String password, String stored) {
        try {
            String[] saltAndPass = stored.split("\\$");
            if (saltAndPass.length != 2) {
                return false;
            }
            String hashOfInput = PasswordUtils.hash(password, Base64.decodeBase64((String)saltAndPass[0]));
            return hashOfInput.equals(saltAndPass[1]);
        }
        catch (Exception e) {
            logger.error("Erro do algoritmo de Password", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String hash(String password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (password == null || password.length() == 0) {
            throw new IllegalArgumentException("Senha n\u00e3o pode ser vazia.");
        }
        SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        SecretKey key = f.generateSecret(new PBEKeySpec(password.toCharArray(), salt, 1024, 256));
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }

    public static String gerarSenhaRandomica() {
        return RandomStringUtils.randomAlphanumeric((int)8);
    }

    public static String hashMD5(String senha) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(senha.getBytes(), 0, senha.length());
            StringBuffer sb = new StringBuffer();
            for (byte b : md.digest()) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error("Erro no GetInstance(MD5)", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

