/*
 * Decompiled with CFR 0.152.
 */
package br.gov.cgu.utils;

import com.google.common.base.CaseFormat;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.impl.JPAQuery;

public final class JPAQueryUtils {
    public static final String ASC = "asc";

    private JPAQueryUtils() {
    }

    public static void adicionaPaginacao(int pagina, int tamanhoPagina, JPAQuery query) {
        query.limit((long)tamanhoPagina).offset((long)(pagina - 1) * (long)tamanhoPagina);
    }

    public static void adicionaPaginacao(JPAQuery query, int tamanhoPagina, int offset) {
        query.limit((long)tamanhoPagina).offset((long)offset);
    }

    public static void adicionaSort(String sortColumn, Order order, JPAQuery query, Class<?> classe) {
        PathBuilder orderByExpression = new PathBuilder(classe, CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, classe.getSimpleName()));
        query.orderBy(new OrderSpecifier(order, (Expression)orderByExpression.get(sortColumn)));
    }

    public static void adicionaSort(String sortColumn, String order, JPAQuery query, Class<?> classe) {
        PathBuilder orderByExpression = new PathBuilder(classe, CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, classe.getSimpleName()));
        if (ASC.equals(order)) {
            query.orderBy(new OrderSpecifier(Order.ASC, (Expression)orderByExpression.get(sortColumn)));
        } else {
            query.orderBy(new OrderSpecifier(Order.DESC, (Expression)orderByExpression.get(sortColumn)));
        }
    }
}

